/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import com.google.gson.Gson;
import java.util.Arrays;
import org.eclipse.ui.IViewPart;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Sensor;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.ChartType;
import org.netxms.ui.eclipse.charts.widgets.Chart;
import org.netxms.ui.eclipse.compatibility.GraphItem;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.dashboard.widgets.ComparisonChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.internal.ObjectStatusChartConfig;

public class ObjectStatusChartElement
extends ComparisonChartElement {
    private ObjectStatusChartConfig elementConfig;

    public ObjectStatusChartElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.elementConfig = (ObjectStatusChartConfig)new Gson().fromJson(element.getData(), ObjectStatusChartConfig.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.elementConfig = new ObjectStatusChartConfig();
        }
        this.processCommonSettings(this.elementConfig);
        this.refreshInterval = this.elementConfig.getRefreshRate();
        ChartConfiguration chartConfig = new ChartConfiguration();
        chartConfig.setTitleVisible(false);
        chartConfig.setLegendPosition(2);
        chartConfig.setLegendVisible(this.elementConfig.isShowLegend());
        chartConfig.setTransposed(this.elementConfig.isTransposed());
        chartConfig.setTranslucent(this.elementConfig.isTranslucent());
        this.chart = new Chart(this.getContentArea(), 0, ChartType.BAR, chartConfig);
        int i = 0;
        while (i <= ObjectStatus.UNKNOWN.getValue()) {
            this.chart.addParameter(new GraphItem(StatusDisplayInfo.getStatusText((int)i), StatusDisplayInfo.getStatusText((int)i), null));
            this.chart.setPaletteEntry(i, new ChartColor(StatusDisplayInfo.getStatusColor((int)i).getRGB()));
            ++i;
        }
        this.chart.rebuild();
        this.startRefreshTimer();
    }

    @Override
    protected ChartDciConfig[] getDciList() {
        return null;
    }

    @Override
    protected void refreshData() {
        int[] objectCount = new int[6];
        Arrays.fill(objectCount, 0);
        AbstractObject root = this.session.findObjectById(this.getEffectiveObjectId(this.elementConfig.getRootObject()));
        if (root != null) {
            this.collectData(objectCount, root);
        }
        int i = 0;
        while (i < objectCount.length) {
            this.chart.updateParameter(i, (double)objectCount[i], false);
            ++i;
        }
        this.chart.refresh();
    }

    private void collectData(int[] objectCount, AbstractObject root) {
        for (AbstractObject o : root.getAllChildren(-1)) {
            if (o.getStatus().compareTo((Enum)ObjectStatus.UNKNOWN) > 0 || !this.filterObject(o)) continue;
            int n = o.getStatus().getValue();
            objectCount[n] = objectCount[n] + 1;
        }
    }

    private boolean filterObject(AbstractObject o) {
        return o instanceof Node || o instanceof MobileDevice || o instanceof Sensor || o instanceof AccessPoint;
    }
}

