/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.dialogs;

import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.constants.RCC;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class AlarmStateChangeFailureDialog
extends Dialog {
    private SortableTableViewer alarmList;
    private Map<Long, Integer> failures;

    public AlarmStateChangeFailureDialog(Shell parentShell, Map<Long, Integer> failures) {
        super(parentShell);
        this.failures = failures;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Alarm State Change Errors");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        Label text = new Label(dialogArea, 0);
        text.setText("State of some alarms was not changed due to following reasons:");
        String[] names = new String[]{"ID", "Reason"};
        int[] widths = new int[]{80, 250};
        this.alarmList = new SortableTableViewer(dialogArea, names, widths, 0, 128, 68098);
        this.alarmList.setContentProvider((IContentProvider)new MapContentProvider());
        this.alarmList.setLabelProvider((IBaseLabelProvider)new FailuresLabelProvider());
        this.alarmList.setInput(this.failures);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 350;
        this.alarmList.getTable().setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        super.okPressed();
    }

    private class FailuresLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private FailuresLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return columnIndex == 0 ? ((Map.Entry)element).getKey().toString() : RCC.getText((int)((Integer)((Map.Entry)element).getValue()), (String)Locale.getDefault().getLanguage(), null);
        }
    }

    private class MapContentProvider
    implements IStructuredContentProvider {
        private MapContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return null;
            }
            if (inputElement instanceof Map) {
                return ((Map)inputElement).entrySet().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }
    }
}

