/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.netxms.nxmc.base.jobs.Job;
import org.netxms.nxmc.base.jobs.JobManager;
import org.netxms.nxmc.base.jobs.JobState;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.MessageAreaHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Job {
    private static final Logger logger = LoggerFactory.getLogger(Job.class);
    private static final int TYPE_SYSTEM = 0;
    private static final int TYPE_DEFAULT = 1;
    private static final int TYPE_USER = 2;
    private int id = -1;
    private JobState state = JobState.PENDING;
    private Display display;
    private View view;
    private MessageAreaHolder messageArea;
    private String name;
    private int type;
    private IProgressMonitor monitor;

    public Job(String name, View view) {
        this(name, view, (MessageAreaHolder)view, Display.getCurrent());
    }

    public Job(String name, View view, MessageAreaHolder messageArea) {
        this(name, view, (MessageAreaHolder)(messageArea != null ? messageArea : view), Display.getCurrent());
    }

    public Job(String name, View view, MessageAreaHolder messageArea, Display display) {
        this.name = name;
        this.type = 2;
        this.view = view;
        this.messageArea = messageArea != null ? messageArea : view;
        this.display = display;
    }

    protected void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public JobState getState() {
        return this.state;
    }

    protected final void execute(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new JobProgressMonitor(this);
        }
        this.monitor = monitor;
        this.state = JobState.RUNNING;
        try {
            monitor.beginTask(this.name, -1);
            this.run(monitor);
        }
        catch (Exception e) {
            logger.error("Exception in UI job - " + e.getMessage(), (Throwable)e);
            this.jobFailureHandler(e);
            if (this.messageArea != null) {
                this.runInUIThread(() -> this.messageArea.addMessage(3, this.getErrorMessage() + ": " + e.getLocalizedMessage()));
            }
        }
        finally {
            monitor.done();
            this.jobFinalize();
            this.state = JobState.COMPLETED;
            if (this.view != null) {
                this.runInUIThread(() -> this.view.onJobCompletion(this.id));
            }
        }
    }

    public void start() {
        JobManager.getInstance().submit(this, null);
    }

    public void start(IProgressMonitor monitor) {
        JobManager.getInstance().submit(this, monitor);
    }

    public void schedule(long delay) {
        JobManager.getInstance().schedule(this, delay);
    }

    public void runInForeground() {
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(null);
        try {
            monitorDialog.run(true, false, (IRunnableWithProgress)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            logger.error("Exception in foreground UI job - " + e.getMessage(), (Throwable)e);
        }
    }

    public void setSystem(boolean system) {
        if (system) {
            this.type = 0;
        } else if (this.type == 0) {
            this.type = 1;
        }
    }

    public boolean isSystem() {
        return this.type == 0;
    }

    public void setUser(boolean user) {
        if (user) {
            this.type = 2;
        } else if (this.type == 2) {
            this.type = 1;
        }
    }

    public boolean isUser() {
        return this.type == 2;
    }

    public String getName() {
        return this.name;
    }

    public View getView() {
        return this.view;
    }

    protected abstract void run(IProgressMonitor var1) throws Exception;

    protected abstract String getErrorMessage();

    protected void jobFailureHandler(Exception e) {
    }

    protected void jobFinalize() {
    }

    protected void runInUIThread(Runnable runnable) {
        if (!this.display.isDisposed()) {
            this.display.asyncExec(runnable);
        }
    }

    protected Display getDisplay() {
        return this.display;
    }

    protected void setScheduledState() {
        this.state = JobState.SCHEDULED;
    }

    public void cancel() {
        if (this.state == JobState.RUNNING) {
            this.canceling();
            this.monitor.setCanceled(true);
        }
    }

    protected void canceling() {
    }
}

