/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.charts.api.GaugeColorMode;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.GaugeConfig;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class Gauge
extends DashboardElementPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(Gauge.class);
    private GaugeConfig config;
    private Combo gaugeType;
    private LabeledText fontName;
    private LabeledSpinner fontSize;
    private LabeledSpinner expectedTextWidth;
    private Button checkLegendInside;
    private Button checkVertical;
    private Button checkElementBorders;
    private LabeledText minValue;
    private LabeledText maxValue;
    private LabeledText leftYellowZone;
    private LabeledText leftRedZone;
    private LabeledText rightYellowZone;
    private LabeledText rightRedZone;
    private Combo colorMode;
    private ColorSelector customColor;
    private ObjectSelector drillDownObject;

    public Gauge(DashboardElementConfig elementConfig) {
        super(LocalizationHelper.getI18n(Gauge.class).tr("Gauge"), elementConfig);
    }

    public String getId() {
        return "gauge";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof GaugeConfig;
    }

    public int getPriority() {
        return 10;
    }

    protected Control createContents(Composite parent) {
        this.config = (GaugeConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.gaugeType = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)this.i18n.tr("Gauge type"), (Object)gd);
        this.gaugeType.add(this.i18n.tr("Dial"));
        this.gaugeType.add(this.i18n.tr("Bar"));
        this.gaugeType.add(this.i18n.tr("Text"));
        this.gaugeType.add(this.i18n.tr("Circular"));
        this.gaugeType.select(this.config.getGaugeType());
        this.fontName = new LabeledText(dialogArea, 0);
        this.fontName.setLabel(this.i18n.tr("Font name (leave empty to use default)"));
        this.fontName.setText(this.config.getFontName());
        gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.fontName.setLayoutData((Object)gd);
        this.fontSize = new LabeledSpinner(dialogArea, 0);
        this.fontSize.setLabel(this.i18n.tr("Font size (0 for autoscale)"));
        this.fontSize.setRange(0, 72);
        this.fontSize.setSelection(this.config.getFontSize());
        gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.horizontalAlignment = 4;
        this.fontSize.setLayoutData((Object)gd);
        this.expectedTextWidth = new LabeledSpinner(dialogArea, 0);
        this.expectedTextWidth.setLabel(this.i18n.tr("Expected text width (0 for autoscale)"));
        this.expectedTextWidth.setRange(0, 1000);
        this.expectedTextWidth.setSelection(this.config.getExpectedTextWidth());
        gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.horizontalAlignment = 4;
        this.expectedTextWidth.setLayoutData((Object)gd);
        this.minValue = new LabeledText(dialogArea, 0);
        this.minValue.setLabel(this.i18n.tr("Minimum value"));
        this.minValue.setText(Double.toString(this.config.getMinValue()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.minValue.setLayoutData((Object)gd);
        this.maxValue = new LabeledText(dialogArea, 0);
        this.maxValue.setLabel(this.i18n.tr("Maximum value"));
        this.maxValue.setText(Double.toString(this.config.getMaxValue()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.maxValue.setLayoutData((Object)gd);
        this.leftRedZone = new LabeledText(dialogArea, 0);
        this.leftRedZone.setLabel(this.i18n.tr("Left red zone end"));
        this.leftRedZone.setText(Double.toString(this.config.getLeftRedZone()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.leftRedZone.setLayoutData((Object)gd);
        this.leftYellowZone = new LabeledText(dialogArea, 0);
        this.leftYellowZone.setLabel(this.i18n.tr("Left yellow zone end"));
        this.leftYellowZone.setText(Double.toString(this.config.getLeftYellowZone()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.leftYellowZone.setLayoutData((Object)gd);
        this.rightYellowZone = new LabeledText(dialogArea, 0);
        this.rightYellowZone.setLabel(this.i18n.tr("Right yellow zone start"));
        this.rightYellowZone.setText(Double.toString(this.config.getRightYellowZone()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.rightYellowZone.setLayoutData((Object)gd);
        this.rightRedZone = new LabeledText(dialogArea, 0);
        this.rightRedZone.setLabel(this.i18n.tr("Right red zone start"));
        this.rightRedZone.setText(Double.toString(this.config.getRightRedZone()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.rightRedZone.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.colorMode = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)this.i18n.tr("Color mode"), (Object)gd);
        this.colorMode.add(this.i18n.tr("Zone color"));
        this.colorMode.add(this.i18n.tr("Fixed custom color"));
        this.colorMode.add(this.i18n.tr("Active threshold color"));
        this.colorMode.add(this.i18n.tr("Data source color"));
        this.colorMode.select(this.config.getColorMode());
        this.colorMode.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        this.customColor = WidgetHelper.createLabeledColorSelector((Composite)dialogArea, (String)this.i18n.tr("Custom color"), (Object)gd);
        this.customColor.setColorValue(ColorConverter.rgbFromInt((int)this.config.getCustomColor()));
        this.drillDownObject = new ObjectSelector(dialogArea, 0, true);
        this.drillDownObject.setLabel(this.i18n.tr("Drill-down object"));
        this.drillDownObject.setObjectClass(AbstractObject.class);
        this.drillDownObject.setClassFilter(ObjectSelectionDialog.createDashboardAndNetworkMapSelectionFilter());
        this.drillDownObject.setObjectId(this.config.getDrillDownObjectId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.drillDownObject.setLayoutData((Object)gd);
        this.checkLegendInside = new Button(dialogArea, 32);
        this.checkLegendInside.setText(this.i18n.tr("Place legend &inside dial"));
        this.checkLegendInside.setSelection(this.config.isLegendInside());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkLegendInside.setLayoutData((Object)gd);
        this.checkVertical = new Button(dialogArea, 32);
        this.checkVertical.setText(this.i18n.tr("&Vertical orientation"));
        this.checkVertical.setSelection(this.config.isVertical());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkVertical.setLayoutData((Object)gd);
        this.checkElementBorders = new Button(dialogArea, 32);
        this.checkElementBorders.setText(this.i18n.tr("Show &border around each element"));
        this.checkElementBorders.setSelection(this.config.isElementBordersVisible());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkElementBorders.setLayoutData((Object)gd);
        this.onColorModeChange(this.config.getColorMode());
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        double rr;
        double ry;
        double lr;
        double ly;
        double max;
        double min;
        try {
            min = Double.parseDouble(this.minValue.getText().trim());
            max = Double.parseDouble(this.maxValue.getText().trim());
            ly = Double.parseDouble(this.leftYellowZone.getText().trim());
            lr = Double.parseDouble(this.leftRedZone.getText().trim());
            ry = Double.parseDouble(this.rightYellowZone.getText().trim());
            rr = Double.parseDouble(this.rightRedZone.getText().trim());
        }
        catch (NumberFormatException e) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please enter correct number"));
            return false;
        }
        this.config.setGaugeType(this.gaugeType.getSelectionIndex());
        this.config.setFontName(this.fontName.getText().trim());
        this.config.setFontSize(this.fontSize.getSelection());
        this.config.setExpectedTextWidth(this.expectedTextWidth.getSelection());
        this.config.setMinValue(min);
        this.config.setMaxValue(max);
        this.config.setLeftYellowZone(ly);
        this.config.setLeftRedZone(lr);
        this.config.setRightYellowZone(ry);
        this.config.setRightRedZone(rr);
        this.config.setLegendInside(this.checkLegendInside.getSelection());
        this.config.setVertical(this.checkVertical.getSelection());
        this.config.setElementBordersVisible(this.checkElementBorders.getSelection());
        this.config.setColorMode(this.colorMode.getSelectionIndex());
        this.config.setCustomColor(ColorConverter.rgbToInt((RGB)this.customColor.getColorValue()));
        this.config.setDrillDownObjectId(this.drillDownObject.getObjectId());
        return true;
    }

    private void onColorModeChange(int newMode) {
        this.leftYellowZone.setEnabled(newMode == GaugeColorMode.ZONE.getValue());
        this.leftRedZone.setEnabled(newMode == GaugeColorMode.ZONE.getValue());
        this.rightYellowZone.setEnabled(newMode == GaugeColorMode.ZONE.getValue());
        this.rightRedZone.setEnabled(newMode == GaugeColorMode.ZONE.getValue());
        this.customColor.setEnabled(newMode == GaugeColorMode.CUSTOM.getValue());
    }
}

