/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Dashboard;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.layout.DashboardLayout;
import org.netxms.nxmc.base.layout.DashboardLayoutData;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.DashboardElementPropertiesManager;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfigFactory;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementLayout;
import org.netxms.nxmc.modules.dashboards.dialogs.EditElementJsonDlg;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.AlarmViewerElement;
import org.netxms.nxmc.modules.dashboards.widgets.AvailabilityChartElement;
import org.netxms.nxmc.modules.dashboards.widgets.BarChartElement;
import org.netxms.nxmc.modules.dashboards.widgets.CustomWidgetElement;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardModifyListener;
import org.netxms.nxmc.modules.dashboards.widgets.DciSummaryTableElement;
import org.netxms.nxmc.modules.dashboards.widgets.ElementWidget;
import org.netxms.nxmc.modules.dashboards.widgets.EmbeddedDashboardElement;
import org.netxms.nxmc.modules.dashboards.widgets.EventMonitorElement;
import org.netxms.nxmc.modules.dashboards.widgets.FileMonitorElement;
import org.netxms.nxmc.modules.dashboards.widgets.GaugeElement;
import org.netxms.nxmc.modules.dashboards.widgets.GeoMapElement;
import org.netxms.nxmc.modules.dashboards.widgets.LabelElement;
import org.netxms.nxmc.modules.dashboards.widgets.LineChartElement;
import org.netxms.nxmc.modules.dashboards.widgets.NetworkMapElement;
import org.netxms.nxmc.modules.dashboards.widgets.ObjectQuery;
import org.netxms.nxmc.modules.dashboards.widgets.ObjectStatusChartElement;
import org.netxms.nxmc.modules.dashboards.widgets.ObjectTools;
import org.netxms.nxmc.modules.dashboards.widgets.PieChartElement;
import org.netxms.nxmc.modules.dashboards.widgets.PortViewElement;
import org.netxms.nxmc.modules.dashboards.widgets.RackDiagramElement;
import org.netxms.nxmc.modules.dashboards.widgets.ScriptedBarChartElement;
import org.netxms.nxmc.modules.dashboards.widgets.ScriptedPieChartElement;
import org.netxms.nxmc.modules.dashboards.widgets.SeparatorElement;
import org.netxms.nxmc.modules.dashboards.widgets.ServiceComponentsElement;
import org.netxms.nxmc.modules.dashboards.widgets.SnmpTrapMonitorElement;
import org.netxms.nxmc.modules.dashboards.widgets.StatusIndicatorElement;
import org.netxms.nxmc.modules.dashboards.widgets.StatusMapElement;
import org.netxms.nxmc.modules.dashboards.widgets.SyslogMonitorElement;
import org.netxms.nxmc.modules.dashboards.widgets.TableBarChartElement;
import org.netxms.nxmc.modules.dashboards.widgets.TablePieChartElement;
import org.netxms.nxmc.modules.dashboards.widgets.TableValueElement;
import org.netxms.nxmc.modules.dashboards.widgets.WebPageElement;
import org.netxms.nxmc.resources.ThemeEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class DashboardControl
extends Composite {
    private static final Logger logger = LoggerFactory.getLogger(DashboardControl.class);
    public static final String DEFAULT_CHART_CONFIG = "<element>\n\t<dciList length=\"0\">\n\t</dciList>\n</element>";
    public static final String DEFAULT_LINE_CHART_CONFIG = "<element>\n\t<dciList length=\"0\">\n\t</dciList>\n</element>";
    public static final String DEFAULT_DIAL_CHART_CONFIG = "<element>\n\t<maxValue>100</maxValue>\n\t<yellowZone>70</yellowZone>\n\t<redZone>90</redZone>\n\t<dciList length=\"0\">\n\t</dciList>\n</element>";
    public static final String DEFAULT_AVAILABILITY_CHART_CONFIG = "<element>\n\t<objectId>9</objectId>\n</element>";
    public static final String DEFAULT_TABLE_CHART_CONFIG = "<element>\n\t<nodeId>0</nodeId>\n\t<dciId>0</dciId>\n\t<dataColumn>DATA</dataColumn>\n</element>";
    public static final String DEFAULT_OBJECT_REFERENCE_CONFIG = "<element>\n\t<objectId>0</objectId>\n</element>";
    public static final String DEFAULT_LABEL_CONFIG = "<element>\n\t<title>Label</title>\n</element>";
    public static final String DEFAULT_NETWORK_MAP_CONFIG = "<element>\n\t<objectId>0</objectId>\n\t<title></title>\n</element>";
    public static final String DEFAULT_GEO_MAP_CONFIG = "<element>\n\t<latitude>0</latitude>\n\t<longitude>0</longitude>\n\t<zoom>8</zoom>\t<title></title>\n</element>";
    public static final String DEFAULT_WEB_PAGE_CONFIG = "<element>\n\t<url>http://</url>\n\t<title></title>\n</element>";
    public static final String DEFAULT_TABLE_VALUE_CONFIG = "<element>\n\t<objectId>0</objectId>\n\t<dciId>0</dciId>\n\t<title></title>\n</element>";
    public static final String DEFAULT_SUMMARY_TABLE_CONFIG = "<element>\n\t<baseObjectId>0</baseObjectId>\n\t<tableId>0</tableId>\n</element>";
    private final I18n i18n = LocalizationHelper.getI18n(DashboardControl.class);
    private Dashboard dashboard;
    private AbstractObject context;
    private List<DashboardElement> elements;
    private Map<DashboardElement, ElementWidget> elementWidgets = new HashMap();
    private int columnCount;
    private boolean embedded = false;
    private boolean editMode = false;
    private boolean modified = false;
    private boolean narrowScreenMode = false;
    private DashboardModifyListener modifyListener = null;
    private AbstractDashboardView view;

    public DashboardControl(Composite parent, int style, Dashboard dashboard, AbstractObject context, AbstractDashboardView view, boolean embedded, boolean narrowScreenMode) {
        super(parent, style);
        this.dashboard = dashboard;
        this.context = context;
        this.embedded = embedded;
        this.narrowScreenMode = narrowScreenMode;
        this.elements = new ArrayList(dashboard.getElements());
        this.columnCount = dashboard.getNumColumns();
        this.view = view;
        this.createContent();
    }

    public DashboardControl(Composite parent, int style, DashboardControl originalControl) {
        super(parent, style);
        this.dashboard = originalControl.dashboard;
        this.embedded = originalControl.embedded;
        this.modified = originalControl.modified;
        this.narrowScreenMode = originalControl.narrowScreenMode;
        this.elements = new ArrayList(originalControl.elements);
        this.columnCount = originalControl.columnCount;
        this.view = originalControl.view;
        this.createContent();
    }

    private void createContent() {
        this.setBackground(ThemeEngine.getBackgroundColor((String)"Dashboard"));
        if (this.narrowScreenMode) {
            GridLayout layout = new GridLayout();
            layout.marginWidth = this.embedded ? 0 : 8;
            layout.marginHeight = layout.marginWidth;
            layout.verticalSpacing = 8;
            this.setLayout((Layout)layout);
            ArrayList<ElementInfo> filteredElements = new ArrayList<ElementInfo>();
            for (DashboardElement dashboardElement : this.elements) {
                ElementInfo ei = new ElementInfo(dashboardElement);
                if (!ei.layout.showInNarrowScreenMode) continue;
                boolean inserted = false;
                for (int i = 0; i < filteredElements.size(); ++i) {
                    if (((ElementInfo)filteredElements.get((int)i)).layout.narrowScreenOrder <= ei.layout.narrowScreenOrder) continue;
                    filteredElements.add(i, ei);
                    inserted = true;
                    break;
                }
                if (inserted) continue;
                filteredElements.add(ei);
            }
            for (ElementInfo elementInfo : filteredElements) {
                this.createElementWidget(elementInfo.element);
            }
        } else {
            DashboardLayout layout = new DashboardLayout();
            layout.numColumns = this.columnCount;
            layout.marginWidth = this.embedded ? 0 : 8;
            layout.marginHeight = this.embedded ? 0 : 8;
            layout.horizontalSpacing = 8;
            layout.verticalSpacing = 8;
            layout.scrollable = this.dashboard.isScrollable();
            this.setLayout((Layout)layout);
            for (DashboardElement e : this.elements) {
                this.createElementWidget(e);
            }
        }
    }

    private ElementWidget createElementWidget(DashboardElement e) {
        AlarmViewerElement w = switch (e.getType()) {
            case 11 -> new AlarmViewerElement(this, e, this.view);
            case 12 -> new AvailabilityChartElement(this, e, this.view);
            case 2, 4 -> new BarChartElement(this, e, this.view);
            case 9 -> new CustomWidgetElement(this, e, this.view);
            case 7 -> new EmbeddedDashboardElement(this, e, this.view);
            case 21 -> new DciSummaryTableElement(this, e, this.view);
            case 13 -> new GaugeElement(this, e, this.view);
            case 24 -> new EventMonitorElement(this, e, this.view);
            case 32 -> new FileMonitorElement(this, e, this.view);
            case 10 -> new GeoMapElement(this, e, this.view);
            case 0 -> new LabelElement(this, e, this.view);
            case 1 -> new LineChartElement(this, e, this.view);
            case 8 -> new NetworkMapElement(this, e, this.view);
            case 28 -> new ObjectQuery(this, e, this.view);
            case 27 -> new ObjectTools(this, e, this.view);
            case 3 -> new PieChartElement(this, e, this.view);
            case 29 -> new PortViewElement(this, e, this.view);
            case 26 -> new RackDiagramElement(this, e, this.view);
            case 30 -> new ScriptedBarChartElement(this, e, this.view);
            case 31 -> new ScriptedPieChartElement(this, e, this.view);
            case 18 -> new SeparatorElement(this, e, this.view);
            case 25 -> new ServiceComponentsElement(this, e, this.view);
            case 23 -> new SnmpTrapMonitorElement(this, e, this.view);
            case 5 -> new ObjectStatusChartElement(this, e, this.view);
            case 6 -> new StatusIndicatorElement(this, e, this.view);
            case 20 -> new StatusMapElement(this, e, this.view);
            case 22 -> new SyslogMonitorElement(this, e, this.view);
            case 15, 17 -> new TableBarChartElement(this, e, this.view);
            case 16 -> new TablePieChartElement(this, e, this.view);
            case 19 -> new TableValueElement(this, e, this.view);
            case 14 -> new WebPageElement(this, e, this.view);
            default -> new ElementWidget(this, e, this.view);
        };
        DashboardElementLayout el = w.getElementLayout();
        if (this.narrowScreenMode) {
            GridData gd = new GridData();
            if (el.narrowScreenHeightHint > 0) {
                gd.heightHint = el.narrowScreenHeightHint;
            } else if (el.heightHint > 0) {
                gd.heightHint = el.heightHint;
            }
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            w.setLayoutData((Object)gd);
        } else {
            DashboardLayoutData gd = new DashboardLayoutData();
            gd.fill = el.grabVerticalSpace;
            gd.horizontalSpan = el.horizontalSpan;
            gd.verticalSpan = el.verticalSpan;
            gd.heightHint = el.heightHint;
            w.setLayoutData((Object)gd);
        }
        this.elementWidgets.put(e, w);
        return w;
    }

    private void redoLayout() {
        if (this.editMode) {
            this.setEditMode(false);
            this.layout(true, true);
            this.setEditMode(true);
        } else {
            this.layout(true, true);
        }
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
        for (Control c : this.getChildren()) {
            if (!(c instanceof ElementWidget)) continue;
            ((ElementWidget)c).setEditMode(editMode);
        }
    }

    void moveElement(DashboardElement element, int direction) {
        int index = this.elements.indexOf(element);
        if (index == -1) {
            return;
        }
        ElementWidget w = (ElementWidget)this.elementWidgets.get(element);
        if (direction == 16384 && index > 0) {
            Collections.swap(this.elements, index, index - 1);
            w.moveAbove((Control)this.elementWidgets.get(this.elements.get(index)));
        } else if (direction == 131072 && index < this.elements.size() - 1) {
            Collections.swap(this.elements, index, index + 1);
            w.moveBelow((Control)this.elementWidgets.get(this.elements.get(index)));
        } else {
            return;
        }
        this.redoLayout();
        this.setModified();
    }

    void changeElementSpan(DashboardElement element, int hSpanChange, int vSpanChange) {
        ElementWidget w = (ElementWidget)this.elementWidgets.get(element);
        if (w == null) {
            return;
        }
        DashboardElementLayout el = w.getElementLayout();
        int hSpan = el.horizontalSpan + hSpanChange;
        int vSpan = el.verticalSpan + vSpanChange;
        if (hSpan < 1 || vSpan < 1 || hSpan > this.columnCount) {
            return;
        }
        el.horizontalSpan = hSpan;
        el.verticalSpan = vSpan;
        try {
            element.setLayout(new Gson().toJson((Object)el));
        }
        catch (Exception e) {
            logger.error("Error serializing updated dashboard element layout", (Throwable)e);
        }
        DashboardLayoutData gd = (DashboardLayoutData)w.getLayoutData();
        gd.horizontalSpan = el.horizontalSpan;
        gd.verticalSpan = el.verticalSpan;
        this.redoLayout();
        this.setModified();
    }

    void setElementFullHSpan(DashboardElement element) {
        ElementWidget w = (ElementWidget)this.elementWidgets.get(element);
        if (w == null) {
            return;
        }
        DashboardElementLayout el = w.getElementLayout();
        if (el.horizontalSpan == this.columnCount) {
            return;
        }
        el.horizontalSpan = this.columnCount;
        try {
            element.setLayout(new Gson().toJson((Object)el));
        }
        catch (Exception e) {
            logger.error("Error serializing updated dashboard element layout", (Throwable)e);
        }
        DashboardLayoutData gd = (DashboardLayoutData)w.getLayoutData();
        gd.horizontalSpan = el.horizontalSpan;
        this.redoLayout();
        this.setModified();
    }

    void duplicateElement(DashboardElement src) {
        DashboardElement element = new DashboardElement(src);
        element.setIndex(this.elements.size());
        this.elements.add(element);
        this.createElementWidget(element);
        this.redoLayout();
        this.setModified();
    }

    void deleteElement(DashboardElement element) {
        this.elements.remove(element);
        ElementWidget w = (ElementWidget)this.elementWidgets.get(element);
        if (w != null) {
            this.elementWidgets.remove(element);
            w.dispose();
            this.redoLayout();
        }
        this.setModified();
    }

    private Control getNextWidget(Control curr) {
        Control[] children = this.getChildren();
        for (int i = 0; i < children.length - 1; ++i) {
            if (children[i] != curr) continue;
            return children[i + 1];
        }
        return null;
    }

    void editElement(DashboardElement element) {
        DashboardElementConfig config = DashboardElementConfigFactory.create((DashboardElement)element);
        if (config == null) {
            this.view.addMessage(3, this.i18n.tr("Internal error (cannot parse element configuration)"));
            return;
        }
        try {
            Gson gson = new Gson();
            config.setLayout((DashboardElementLayout)gson.fromJson(element.getLayout(), DashboardElementLayout.class));
            if (!DashboardElementPropertiesManager.openElementPropertiesDialog((DashboardElementConfig)config, (Shell)this.getShell())) {
                return;
            }
            element.setData(config.createJson());
            element.setLayout(gson.toJson((Object)config.getLayout()));
            this.recreateElement(element);
            this.redoLayout();
            this.setModified();
        }
        catch (Exception e) {
            this.view.addMessage(3, String.format(this.i18n.tr("Internal error (%s)"), e.getLocalizedMessage()));
        }
    }

    void editElementJson(DashboardElement element) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Object json = gson.fromJson(element.getData(), Object.class);
        EditElementJsonDlg dlg = new EditElementJsonDlg(this.getShell(), gson.toJson(json));
        if (dlg.open() == 0) {
            element.setData(dlg.getValue());
            this.recreateElement(element);
            this.redoLayout();
            this.setModified();
        }
    }

    private void recreateElement(DashboardElement element) {
        ElementWidget w = (ElementWidget)this.elementWidgets.get(element);
        Control next = this.getNextWidget((Control)w);
        w.dispose();
        w = this.createElementWidget(element);
        if (next != null) {
            w.moveAbove(next);
        }
        this.elementWidgets.put(element, w);
    }

    public void addElement(DashboardElement element) {
        DashboardElementConfig config = DashboardElementConfigFactory.create((DashboardElement)element);
        if (config == null) {
            this.view.addMessage(3, this.i18n.tr("Cannot add dashboard element (internal error)"));
            return;
        }
        try {
            Gson gson = new Gson();
            config.setLayout((DashboardElementLayout)gson.fromJson(element.getLayout(), DashboardElementLayout.class));
            if (!DashboardElementPropertiesManager.openElementPropertiesDialog((DashboardElementConfig)config, (Shell)this.getShell())) {
                return;
            }
            element.setData(config.createJson());
            element.setLayout(gson.toJson((Object)config.getLayout()));
            this.elements.add(element);
            this.createElementWidget(element);
            this.redoLayout();
            this.setModified();
        }
        catch (Exception e) {
            this.view.addMessage(3, String.format(this.i18n.tr("Cannot add dashboard element (internal error - %s)"), e.getLocalizedMessage()));
        }
    }

    public void addColumn() {
        if (this.columnCount == 128) {
            return;
        }
        ++this.columnCount;
        ((DashboardLayout)this.getLayout()).numColumns = this.columnCount;
        this.layout(true, true);
        this.setModified();
    }

    public void removeColumn() {
        if (this.columnCount == this.getMinimalColumnCount()) {
            return;
        }
        --this.columnCount;
        ((DashboardLayout)this.getLayout()).numColumns = this.columnCount;
        this.layout(true, true);
        this.setModified();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getMinimalColumnCount() {
        int count = 1;
        for (DashboardElement element : this.elements) {
            try {
                DashboardElementLayout layout = (DashboardElementLayout)new Gson().fromJson(element.getLayout(), DashboardElementLayout.class);
                if (layout.horizontalSpan <= count) continue;
                count = layout.horizontalSpan;
            }
            catch (Exception e) {
                logger.error("Cannot parse dashboard element layout", (Throwable)e);
            }
        }
        return count;
    }

    public void saveDashboard() {
        NXCObjectModificationData md = new NXCObjectModificationData(this.dashboard.getObjectId());
        md.setDashboardElements(new ArrayList(this.elements));
        md.setColumnCount(this.columnCount);
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void setModified() {
        this.modified = true;
        if (this.modifyListener != null) {
            this.modifyListener.modify();
        }
    }

    public DashboardModifyListener getModifyListener() {
        return this.modifyListener;
    }

    public void setModifyListener(DashboardModifyListener modifyListener) {
        this.modifyListener = modifyListener;
    }

    public boolean isModified() {
        return this.modified;
    }

    public List<DashboardElement> getElements() {
        return this.elements;
    }

    public List<ElementWidget> getElementWidgets() {
        return new ArrayList<ElementWidget>(this.elementWidgets.values());
    }

    public Dashboard getDashboardObject() {
        return this.dashboard;
    }

    public AbstractObject getContext() {
        return this.context;
    }

    public boolean isNarrowScreenMode() {
        return this.narrowScreenMode;
    }

    public void requestDashboardLayout() {
        if (this.view != null) {
            this.view.requestDashboardLayout();
        } else {
            this.layout(true, true);
        }
    }
}

