/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.ConditionDciInfo;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Condition;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.dialogs.SelectDciDialog;
import org.netxms.nxmc.modules.objects.dialogs.ConditionDciEditDialog;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.propertypages.helpers.ConditionDciListLabelProvider;
import org.xnap.commons.i18n.I18n;

public class ConditionData
extends ObjectPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(ConditionData.class);
    public static final int COLUMN_POSITION = 0;
    public static final int COLUMN_NODE = 1;
    public static final int COLUMN_METRIC = 2;
    public static final int COLUMN_FUNCTION = 3;
    private Condition condition = null;
    private ConditionDciListLabelProvider labelProvider;
    private SortableTableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    private List<ConditionDciInfo> dciList = null;
    private boolean isModified = false;

    public ConditionData(AbstractObject object) {
        super(LocalizationHelper.getI18n(ConditionData.class).tr("Data"), object);
    }

    public String getId() {
        return "conditionData";
    }

    public int getPriority() {
        return 10;
    }

    public boolean isVisible() {
        return this.object instanceof Condition;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.condition = (Condition)this.object;
        this.dciList = new ArrayList();
        for (ConditionDciInfo dci : this.condition.getDciList()) {
            this.dciList.add(new ConditionDciInfo(dci));
        }
        this.labelProvider = new ConditionDciListLabelProvider(this.dciList);
        this.labelProvider.resolveDciNames((Collection)this.condition.getDciList());
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        String[] columnNames = new String[]{this.i18n.tr("Pos"), this.i18n.tr("Node"), this.i18n.tr("Parameter"), this.i18n.tr("Function")};
        int[] columnWidths = new int[]{40, 130, 220, 80};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.disableSorting();
        this.viewer.setInput((Object)this.dciList.toArray());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        gridData.horizontalSpan = 2;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite leftButtons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginLeft = 0;
        leftButtons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gridData);
        this.upButton = new Button(leftButtons, 8);
        this.upButton.setText(this.i18n.tr("&Up"));
        RowData rd = new RowData();
        rd.width = 90;
        this.upButton.setLayoutData((Object)rd);
        this.upButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.upButton.setEnabled(false);
        this.downButton = new Button(leftButtons, 8);
        this.downButton.setText(this.i18n.tr("&Down"));
        rd = new RowData();
        rd.width = 90;
        this.downButton.setLayoutData((Object)rd);
        this.downButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.downButton.setEnabled(false);
        Composite rightButtons = new Composite(dialogArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        rightButtons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        rightButtons.setLayoutData((Object)gridData);
        this.addButton = new Button(rightButtons, 8);
        this.addButton.setText(this.i18n.tr("&Add..."));
        rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editButton = new Button(rightButtons, 8);
        this.editButton.setText(this.i18n.tr("&Modify..."));
        rd = new RowData();
        rd.width = 90;
        this.editButton.setLayoutData((Object)rd);
        this.editButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editButton.setEnabled(false);
        this.deleteButton = new Button(rightButtons, 8);
        this.deleteButton.setText(this.i18n.tr("&Delete"));
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteButton.setEnabled(false);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    private void addItem() {
        SelectDciDialog dlg = new SelectDciDialog(this.getShell(), 0L);
        if (dlg.open() == 0) {
            List selection = dlg.getSelection();
            ArrayList<ConditionDciInfo> select = new ArrayList<ConditionDciInfo>();
            for (DciValue item : selection) {
                ConditionDciInfo dci = new ConditionDciInfo(item.getNodeId(), item.getId(), item.getDcObjectType(), 0, 1);
                this.labelProvider.addCacheEntry(dci.getNodeId(), dci.getDciId(), item.getDescription());
                this.dciList.add(dci);
                select.add(dci);
                this.viewer.setInput((Object)this.dciList.toArray());
                this.isModified = true;
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)dci));
                this.editItem();
            }
            this.viewer.setSelection((ISelection)new StructuredSelection(select));
        }
    }

    private void editItem() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        ConditionDciInfo dci = (ConditionDciInfo)selection.getFirstElement();
        if (dci == null) {
            return;
        }
        ConditionDciEditDialog dlg = new ConditionDciEditDialog(this.getShell(), dci, this.labelProvider.getColumnText((Object)dci, 1), this.labelProvider.getColumnText((Object)dci, 2));
        if (dlg.open() == 0) {
            this.viewer.update((Object)dci, null);
            this.isModified = true;
        }
    }

    private void deleteItems() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object o : selection.toList()) {
            this.dciList.remove(o);
        }
        this.viewer.setInput((Object)this.dciList.toArray());
        this.isModified = true;
    }

    protected boolean applyChanges(boolean isApply) {
        if (!this.isModified) {
            return true;
        }
        if (isApply) {
            this.setValid(false);
        }
        NXCObjectModificationData md = new NXCObjectModificationData(this.condition.getObjectId());
        md.setDciList(this.dciList);
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    private void moveUp() {
        ConditionDciInfo element;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && (index = this.dciList.indexOf(element = (ConditionDciInfo)selection.getFirstElement())) > 0) {
            Collections.swap(this.dciList, index - 1, index);
            this.viewer.setInput((Object)this.dciList.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)element));
            this.isModified = true;
        }
    }

    private void moveDown() {
        ConditionDciInfo element;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && (index = this.dciList.indexOf(element = (ConditionDciInfo)selection.getFirstElement())) < this.dciList.size() - 1 && index >= 0) {
            Collections.swap(this.dciList, index + 1, index);
            this.viewer.setInput((Object)this.dciList.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)element));
        }
    }
}

