/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scrollable;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.client.topology.VlanInfo;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.networkmaps.views.VlanMapView;
import org.netxms.nxmc.modules.objects.ObjectContextMenuManager;
import org.netxms.nxmc.modules.objects.views.NodeSubObjectView;
import org.netxms.nxmc.modules.objects.views.PortView;
import org.netxms.nxmc.modules.objects.views.helpers.VlanLabelProvider;
import org.netxms.nxmc.modules.objects.widgets.PortViewWidget;
import org.netxms.nxmc.modules.objects.widgets.helpers.PortSelectionListener;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class PortView
extends NodeSubObjectView
implements ISelectionProvider {
    private final I18n i18n = LocalizationHelper.getI18n(PortView.class);
    public static final int COLUMN_VLAN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_PORTS = 2;
    public static final int COLUMN_INTERFACES = 3;
    private List<VlanInfo> vlans = new ArrayList(0);
    private VlanLabelProvider labelProvider;
    private DisplayMode displayMode = DisplayMode.NONE;
    private Button buttonState;
    private Button buttonStatus;
    private Button buttonVlan;
    private SortableTableViewer vlanList;
    private boolean objectsFullySync;
    private Action actionShowVlanMap;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;
    private ScrolledComposite scroller;
    private PortViewWidget portView;
    private ISelection selection = new StructuredSelection();
    private Set<ISelectionChangedListener> selectionListeners = new HashSet();

    public PortView() {
        super(LocalizationHelper.getI18n(PortView.class).tr("Ports"), ResourceManager.getImageDescriptor((String)"icons/object-views/ports.png"), "objects.ports", false);
        PreferenceStore store = PreferenceStore.getInstance();
        this.objectsFullySync = store.getAsBoolean("ObjectBrowser.FullSync", false);
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof Node && ((Node)context).isBridge();
    }

    public int getPriority() {
        return 90;
    }

    protected void onObjectChange(AbstractObject object) {
        this.scroller.setMinSize(this.portView.computeSize(-1, -1));
        this.setVlans(new ArrayList());
        if (object != null) {
            this.portView.setNodeId(object != null ? object.getObjectId() : 0L);
            this.refresh();
        }
    }

    protected void createContent(Composite parent) {
        super.createContent(parent);
        this.mainArea.setLayout((Layout)new GridLayout());
        Composite controlBar = new Composite(this.mainArea, 0);
        controlBar.setBackground(this.mainArea.getBackground());
        controlBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        controlBar.setLayout((Layout)new RowLayout(256));
        this.buttonState = new Button(controlBar, 0x800002);
        this.buttonState.setText(this.i18n.tr("State"));
        this.buttonState.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonState.setSelection(true);
        RowData rd = new RowData();
        rd.width = 90;
        this.buttonState.setLayoutData((Object)rd);
        this.buttonStatus = new Button(controlBar, 0x800002);
        this.buttonStatus.setText(this.i18n.tr("Status"));
        this.buttonStatus.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.buttonStatus.setLayoutData((Object)rd);
        this.buttonVlan = new Button(controlBar, 0x800002);
        this.buttonVlan.setText(this.i18n.tr("Vlans"));
        this.buttonVlan.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.buttonVlan.setLayoutData((Object)rd);
        SashForm splitter = new SashForm(this.mainArea, 512);
        splitter.setSashWidth(3);
        splitter.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite deviceViewArea = new Composite((Composite)splitter, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        deviceViewArea.setLayout((Layout)layout);
        this.scroller = new ScrolledComposite(deviceViewArea, 768);
        this.scroller.setLayoutData((Object)new GridData(4, 4, true, true));
        this.portView = new PortViewWidget((Composite)this.scroller, 0);
        this.portView.setPortDisplayMode(1);
        this.portView.setNodeId(this.getObjectId());
        this.portView.addSelectionListener((PortSelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.scroller.setContent((Control)this.portView);
        this.scroller.setBackground(this.portView.getBackground());
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)512, (int)20);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)256, (int)20);
        this.scroller.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        new Label(deviceViewArea, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite vlanListArea = new Composite((Composite)splitter, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        vlanListArea.setLayout((Layout)layout);
        String[] names = new String[]{this.i18n.tr("ID"), this.i18n.tr("Name"), this.i18n.tr("Ports"), "Interfaces"};
        int[] widths = new int[]{80, 180, 400, 400};
        this.vlanList = new SortableTableViewer(vlanListArea, names, widths, 0, 1024, 65538);
        this.vlanList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.labelProvider = new VlanLabelProvider();
        this.vlanList.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.vlanList.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.vlanList.setInput((Object)this.vlans.toArray());
        this.vlanList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.vlanList, (String)"VlanList");
        this.vlanList.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        new Label(vlanListArea, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        splitter.setWeights(new int[]{60, 40});
        this.createContextMenu();
        this.createActions();
        this.createPopupMenu();
    }

    private void createActions() {
        this.actionShowVlanMap = new /* Unavailable Anonymous Inner Class!! */;
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.vlanList, true);
        this.actionExportAllToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.vlanList, false);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.vlanList.getControl());
        this.vlanList.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionShowVlanMap);
        manager.add((IAction)this.actionExportToCsv);
    }

    public void setVlans(List<VlanInfo> vlans) {
        this.vlans = vlans;
        this.vlanList.setInput((Object)vlans.toArray());
    }

    private void showVlanMap() {
        IStructuredSelection selection = this.vlanList.getStructuredSelection();
        for (Object o : selection.toList()) {
            VlanInfo vlan = (VlanInfo)o;
            this.openView((View)new VlanMapView(this.getObject(), vlan.getVlanId()));
        }
    }

    public void refresh() {
        this.portView.setNodeId(this.getObjectId());
        this.scroller.setMinSize(this.portView.computeSize(-1, -1));
        this.labelProvider.setSelectedPort(null);
        String objectName = this.session.getObjectName(this.getObjectId());
        boolean syncChildren = !this.objectsFullySync && !this.session.areChildrenSynchronized(this.getObjectId());
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void switchMode(DisplayMode newMode) {
        if (newMode == this.displayMode) {
            return;
        }
        this.displayMode = newMode;
        switch (11.$SwitchMap$org$netxms$nxmc$modules$objects$views$PortView$DisplayMode[this.displayMode.ordinal()]) {
            case 1: {
                this.portView.setPortDisplayMode(1);
                break;
            }
            case 2: {
                this.portView.setPortDisplayMode(0);
                break;
            }
            default: {
                this.portView.setPortDisplayMode(2);
            }
        }
        this.refresh();
    }

    public boolean needRefreshOnObjectChange(AbstractObject object) {
        return object instanceof Interface && object.isDirectChildOf(this.getObjectId());
    }

    private void createContextMenu() {
        ObjectContextMenuManager menuMgr = new ObjectContextMenuManager((View)this, (ISelectionProvider)this, null);
        this.portView.setMenu(menuMgr.createContextMenu((Control)this.portView));
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }
}

