/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.ClusterResource;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class ClusterResourceListFilter
extends ViewerFilter
implements AbstractViewerFilter {
    private I18n i18n = LocalizationHelper.getI18n(ClusterResourceListFilter.class);
    private String filterString = null;
    private NXCSession session = Registry.getSession();

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        Node owner;
        if (this.filterString == null || this.filterString.isEmpty()) {
            return true;
        }
        ClusterResource resource = (ClusterResource)element;
        if (resource.getVirtualAddress().getHostAddress().contains(this.filterString)) {
            return true;
        }
        if (resource.getName().toLowerCase().contains(this.filterString)) {
            return true;
        }
        long ownerId = ((ClusterResource)element).getCurrentOwner();
        Object ownerName = ownerId > 0L ? ((owner = (Node)this.session.findObjectById(ownerId, Node.class)) != null ? owner.getObjectName() : "<" + Long.toString(ownerId) + ">") : this.i18n.tr("NONE");
        return ((String)ownerName).toLowerCase().contains(this.filterString);
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString != null ? filterString.toLowerCase() : null;
    }
}

