/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.PhysicalLink;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.configs.PassiveRackElement;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.modules.objects.widgets.helpers.DecoratingObjectLabelProvider;

public class PhysicalLinkLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private NXCSession session = Registry.getSession();
    private DecoratingObjectLabelProvider objectLabelProvider = new DecoratingObjectLabelProvider();

    public String getObjectText(PhysicalLink link, boolean isLeft) {
        String name = "Unknown";
        AbstractObject object = this.session.findObjectById(isLeft ? link.getLeftObjectId() : link.getRightObjectId());
        if (object instanceof Interface) {
            name = ((Interface)object).getParentNode().getObjectName();
        } else if (object instanceof Rack) {
            name = object.getObjectName();
        }
        return name;
    }

    public String getPortText(PhysicalLink link, boolean isLeft) {
        if (isLeft) {
            return this.getPortTextInternal(link.getLeftObjectId(), link.getLeftPatchPanelId(), link.getLeftPortNumber(), link.getLeftFront());
        }
        return this.getPortTextInternal(link.getRightObjectId(), link.getRightPatchPanelId(), link.getRightPortNumber(), link.getRightFront());
    }

    private String getPortTextInternal(long objectId, long patchPanelId, int portNumber, int side) {
        StringBuilder sb = new StringBuilder();
        AbstractObject obj = this.session.findObjectById(objectId);
        if (obj instanceof Interface) {
            sb.append(obj.getObjectName());
        } else if (obj instanceof Rack) {
            PassiveRackElement el = ((Rack)obj).getPassiveElement(patchPanelId);
            sb.append(el.toString());
            sb.append("/");
            sb.append(portNumber);
            sb.append("/");
            sb.append(side == 0 ? "Front" : "Back");
        }
        return sb.toString();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        AbstractObject object = null;
        switch (columnIndex) {
            case 3: {
                object = this.session.findObjectById(((PhysicalLink)element).getLeftObjectId());
                return object != null && object instanceof Interface ? this.objectLabelProvider.getImage((Object)object) : null;
            }
            case 5: {
                object = this.session.findObjectById(((PhysicalLink)element).getRightObjectId());
                return object != null && object instanceof Interface ? this.objectLabelProvider.getImage((Object)object) : null;
            }
            case 2: {
                object = this.session.findObjectById(((PhysicalLink)element).getLeftObjectId());
                break;
            }
            case 4: {
                object = this.session.findObjectById(((PhysicalLink)element).getRightObjectId());
            }
        }
        if (object != null) {
            if (object instanceof Interface) {
                object = ((Interface)object).getParentNode();
            }
            return object != null ? this.objectLabelProvider.getImage((Object)object) : null;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        PhysicalLink link = (PhysicalLink)element;
        switch (columnIndex) {
            case 0: {
                return Long.toString(link.getId());
            }
            case 1: {
                return link.getDescription();
            }
            case 2: 
            case 4: {
                return this.getObjectText(link, columnIndex == 2);
            }
            case 3: 
            case 5: {
                return this.getPortText(link, columnIndex == 3);
            }
        }
        return null;
    }
}

