/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.topology.RadioInterface;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.tools.ViewerElementUpdater;

public class RadioInterfaceAPLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private TableViewer viewer;
    private NXCSession session = Registry.getSession();

    public RadioInterfaceAPLabelProvider(TableViewer viewer) {
        this.viewer = viewer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        RadioInterface rif = (RadioInterface)element;
        switch (columnIndex) {
            case 5: {
                return rif.getBand().toString();
            }
            case 3: {
                return rif.getBSSID().toString();
            }
            case 6: {
                return rif.getChannel() > 0 ? Integer.toString(rif.getChannel()) : "";
            }
            case 7: {
                return rif.getFrequency() > 0 ? Integer.toString(rif.getFrequency()) + " MHz" : "";
            }
            case 0: {
                return Integer.toString(rif.getIndex());
            }
            case 4: {
                return this.session.getVendorByMac(rif.getBSSID(), (Runnable)new ViewerElementUpdater((ColumnViewer)this.viewer, element));
            }
            case 1: {
                return rif.getName();
            }
            case 2: {
                return rif.getSSID();
            }
            case 8: {
                return Integer.toString(rif.getPowerDBm());
            }
            case 9: {
                return Integer.toString(rif.getPowerMW());
            }
        }
        return null;
    }
}

