/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.modules.objects.widgets.AbstractObjectStatusMap;
import org.netxms.nxmc.modules.objects.widgets.ObjectStatusSunburstDiagram;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.ColorCache;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.FontTools;
import org.netxms.nxmc.tools.WidgetHelper;

public class ObjectStatusSunburstDiagram
extends Canvas
implements PaintListener {
    private AbstractObject rootObject;
    private int maxLvl;
    private int leafObjectCount;
    private float leafObjectSize;
    private int diameter;
    private int centerX;
    private int centerY;
    private ColorCache cCache;
    private Map<Long, ObjectData> objects;
    private List<Integer> fontSize;
    private static final String[] FONT_NAMES = new String[]{"Segoe UI", "Liberation Sans", "DejaVu Sans", "Verdana", "Arial"};
    private Font[] valueFonts;
    private static final int FONT_BASE_SIZE = 7;
    private static final int PADDING_HORIZONTAL = 6;
    private static final int PADDING_VERTICAL = 6;
    private static final int MARGIN = 6;
    private static final int SHIFT = 3;
    private boolean fitToScreen = true;
    private List<ObjectPosition> objectMap = new ArrayList();

    public ObjectStatusSunburstDiagram(Composite parent, AbstractObject rootObject, Collection<AbstractObject> objects) {
        super(parent, 4);
        this.rootObject = rootObject;
        this.cCache = new ColorCache((Control)this);
        this.valueFonts = FontTools.getFonts((String[])FONT_NAMES, (int)7, (int)1, (int)16);
        this.objects = new HashMap();
        if (objects != null) {
            for (AbstractObject o : objects) {
                this.objects.put(o.getObjectId(), new ObjectData(this, o));
            }
        }
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.addPaintListener((PaintListener)this);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void refresh() {
        if (this.rootObject == null) {
            return;
        }
        this.redraw();
    }

    private float drawParts(GC gc, AbstractObject object, int lvl, float degree) {
        gc.setAlpha(255);
        float objectSize = 0.0f;
        for (AbstractObject obj : object.getChildrenAsArray()) {
            int lineNum;
            float currObjsize = 0.0f;
            if (AbstractObjectStatusMap.isContainerObject((AbstractObject)obj)) {
                currObjsize = this.drawParts(gc, obj, lvl + 1, degree);
                if (currObjsize == 0.0f) {
                    if (this.objects != null) continue;
                    currObjsize = this.leafObjectSize;
                }
            } else {
                if (this.objects != null && !this.objects.containsKey(obj.getObjectId())) continue;
                currObjsize = this.leafObjectSize;
            }
            int compensation = Integer.signum(Math.round(degree + currObjsize) - (Math.round(degree) + Math.round(currObjsize)));
            if ((int)degree == 0 && (int)currObjsize == 360) {
                gc.setBackground(this.getDisplay().getSystemColor(1));
                gc.fillOval(this.centerX - this.diameter * lvl / 2 - 3, this.centerY - this.diameter * lvl / 2 - 3, this.diameter * lvl + 6, this.diameter * lvl + 6);
                gc.setBackground(StatusDisplayInfo.getStatusColor((ObjectStatus)obj.getStatus()));
                gc.fillOval(this.centerX - this.diameter * lvl / 2, this.centerY - this.diameter * lvl / 2, this.diameter * lvl, this.diameter * lvl);
            } else {
                gc.setBackground(this.getDisplay().getSystemColor(1));
                gc.fillArc(this.centerX - this.diameter * lvl / 2 - 3, this.centerY - this.diameter * lvl / 2 - 3, this.diameter * lvl + 6, this.diameter * lvl + 6, Math.round(degree), Math.round(currObjsize) + compensation);
                gc.setBackground(StatusDisplayInfo.getStatusColor((ObjectStatus)obj.getStatus()));
                gc.fillArc(this.centerX - this.diameter * lvl / 2, this.centerY - this.diameter * lvl / 2, this.diameter * lvl, this.diameter * lvl, Math.round(degree), Math.round(currObjsize) - 1 + compensation);
            }
            this.objectMap.add(new ObjectPosition(this, degree, degree + currObjsize, lvl, obj));
            Transform oldTransform = new Transform(gc.getDevice());
            gc.getTransform(oldTransform);
            String text = obj.getNameWithAlias();
            Transform tr = new Transform((Device)this.getDisplay());
            tr.translate((float)this.centerX, (float)this.centerY);
            float rotate = 0.0f;
            float middle = degree + currObjsize / 2.0f;
            if (middle >= 90.0f && middle < 180.0f) {
                rotate = 90.0f - (middle - 90.0f);
            }
            if (middle >= 270.0f && middle <= 360.0f) {
                rotate = 90.0f - (middle - 270.0f);
            }
            if (middle >= 0.0f && middle < 90.0f) {
                rotate = -middle;
            }
            if (middle > 180.0f && middle < 270.0f) {
                rotate = -(middle - 180.0f);
            }
            tr.rotate(rotate);
            gc.setTransform(tr);
            gc.setFont(this.valueFonts[(Integer)this.fontSize.get(lvl - 1)]);
            int l = gc.textExtent((String)text).x;
            int h = gc.textExtent((String)text).y;
            if (currObjsize < 360.0f) {
                int sectorHeight = (int)(Math.tan(Math.toRadians(currObjsize / 2.0f)) * (double)(this.diameter / 2 * (lvl - 1)) * 2.0) - 12;
                lineNum = sectorHeight / h;
                if (lineNum < 0 || lineNum > 3) {
                    lineNum = 3;
                }
            } else {
                lineNum = 3;
            }
            text = WidgetHelper.fitStringToArea((GC)gc, (String)text, (int)(this.diameter / 2 - 12), (int)lineNum).getResult();
            h = gc.textExtent((String)text).y;
            gc.setForeground(ColorConverter.selectTextColorByBackgroundColor((Color)StatusDisplayInfo.getStatusColor((ObjectStatus)obj.getStatus()), (ColorCache)this.cCache));
            if (middle >= 90.0f && middle <= 180.0f || middle > 180.0f && middle < 270.0f) {
                l = gc.textExtent((String)text).x;
                gc.drawText(text, -(this.diameter * (lvl - 1)) / 2 - 6 - l - 3, -h / 2, 3);
            } else {
                gc.drawText(text, this.diameter * (lvl - 1) / 2 + 6 + 3, -h / 2, 3);
            }
            gc.setTransform(oldTransform);
            tr.dispose();
            oldTransform.dispose();
            degree += currObjsize;
            objectSize += currObjsize;
        }
        return objectSize;
    }

    private int calculateMaxLVLAndObjCount(AbstractObject object, int level) {
        AbstractObject[] objSet;
        int objectCount = 0;
        int foundObjectsCount = 0;
        for (AbstractObject obj : objSet = object.getChildrenAsArray()) {
            if (this.objects != null) {
                if (AbstractObjectStatusMap.isContainerObject((AbstractObject)obj)) {
                    int tmp = this.calculateMaxLVLAndObjCount(obj, level + 1);
                    if (tmp <= 0) continue;
                    ++foundObjectsCount;
                    objectCount += tmp;
                    continue;
                }
                if (!this.objects.containsKey(obj.getObjectId())) continue;
                ++objectCount;
                continue;
            }
            if (AbstractObjectStatusMap.isContainerObject((AbstractObject)obj)) {
                objectCount += this.calculateMaxLVLAndObjCount(obj, level + 1);
                ++foundObjectsCount;
                continue;
            }
            ++objectCount;
        }
        if (this.objects == null && AbstractObjectStatusMap.isContainerObject((AbstractObject)object) && objectCount == 0) {
            ++objectCount;
        }
        if (foundObjectsCount == 0 && this.maxLvl < level) {
            this.maxLvl = level;
        }
        return objectCount;
    }

    private int calculateLayerSize(AbstractObject object, int level, GC gc) {
        int objCount = 0;
        AbstractObject[] objSet = object.getChildrenAsArray();
        gc.setFont(this.valueFonts[0]);
        for (AbstractObject obj : objSet) {
            int contSize;
            if (AbstractObjectStatusMap.isContainerObject((AbstractObject)obj)) {
                contSize = this.calculateLayerSize(obj, level + 1, gc);
                objCount += contSize;
            } else {
                contSize = 1;
                ++objCount;
            }
            this.calculateOptimalDiameter(obj, level, contSize, gc);
        }
        if (objSet.length == 0) {
            ++objCount;
        }
        return objCount;
    }

    private void calculateOptimalDiameter(AbstractObject obj, int level, int objCount, GC gc) {
        String text = obj.getNameWithAlias();
        int sectorHeight = (int)(Math.tan(Math.toRadians(this.leafObjectSize * (float)objCount / 2.0f)) * (double)(this.diameter * level / 2) * 2.0) - 12;
        if (sectorHeight <= 0) {
            sectorHeight = 1286;
        }
        while (!WidgetHelper.fitStringToRect((GC)gc, (String)text, (int)(this.diameter / 2 - 12), (int)sectorHeight, (int)3)) {
            this.diameter = (int)((double)this.diameter + (double)this.diameter * 0.01);
            sectorHeight = (int)(Math.tan(Math.toRadians(this.leafObjectSize * (float)objCount / 2.0f)) * (double)(this.diameter * level / 2) * 2.0) - 12;
            if (sectorHeight >= 0) continue;
            sectorHeight = 1286;
        }
    }

    private int calculateLayerFontSize(AbstractObject object, int level, GC gc) {
        AbstractObject[] objSet;
        int objCount = 0;
        for (AbstractObject obj : objSet = object.getChildrenAsArray()) {
            int contSize;
            if (AbstractObjectStatusMap.isContainerObject((AbstractObject)obj)) {
                contSize = this.calculateLayerFontSize(obj, level + 1, gc);
                objCount += contSize;
            } else {
                contSize = 1;
                ++objCount;
            }
            Integer optimalFontSie = this.calculateOptimalFontsie(obj, level, contSize, gc);
            if ((Integer)this.fontSize.get(level) <= optimalFontSie) continue;
            this.fontSize.set(level, optimalFontSie);
        }
        if (objSet.length == 0) {
            ++objCount;
        }
        return objCount;
    }

    private Integer calculateOptimalFontsie(AbstractObject obj, int lvl, int objCount, GC gc) {
        String text = obj.getNameWithAlias();
        int sectorHeight = (int)(Math.tan(Math.toRadians(this.leafObjectSize * (float)objCount / 2.0f)) * (double)(this.diameter * lvl / 2) * 2.0) - 12;
        if (sectorHeight < 0) {
            sectorHeight = 1286;
        }
        return WidgetHelper.getBestFittingFontMultiline((GC)gc, (Font[])this.valueFonts, (String)text, (int)(this.diameter / 2 - 12), (int)sectorHeight, (int)3);
    }

    public void recalculateData(GC gc) {
        this.leafObjectCount = this.calculateMaxLVLAndObjCount(this.rootObject, 1);
        this.diameter = 200;
        this.leafObjectSize = 360.0f / (float)this.leafObjectCount;
        if (!this.fitToScreen) {
            this.calculateLayerSize(this.rootObject, 1, gc);
        }
    }

    public void paintControl(PaintEvent e) {
        if (this.rootObject == null) {
            return;
        }
        GC gc = e.gc;
        gc.setAdvanced(true);
        if (!gc.getAdvanced()) {
            gc.drawText("Advanced graphics not supported", 30, 30, true);
            return;
        }
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        gc.setForeground(ThemeEngine.getForegroundColor((String)"StatusMap.Text"));
        gc.setLineWidth(1);
        this.objectMap.clear();
        this.recalculateData(gc);
        Rectangle rect = this.getClientArea();
        --rect.width;
        --rect.height;
        int rectSide = Math.min(rect.width, rect.height);
        this.diameter = Math.max(this.diameter, rectSide / (this.maxLvl + 1));
        this.centerX = rect.x + rectSide / 2;
        this.centerY = rect.y + rectSide / 2;
        this.fontSize = new ArrayList<Integer>(Collections.nCopies(this.maxLvl + 1, 100));
        int squareSide = (int)((double)this.diameter / Math.sqrt(2.0));
        this.fontSize.set(0, WidgetHelper.getBestFittingFontMultiline((GC)gc, (Font[])this.valueFonts, (String)this.rootObject.getNameWithAlias(), (int)squareSide, (int)squareSide, (int)3));
        this.calculateLayerFontSize(this.rootObject, 1, gc);
        Integer prevLVL = 100;
        for (int i = 0; i < this.fontSize.size(); ++i) {
            if (prevLVL < (Integer)this.fontSize.get(i)) {
                this.fontSize.set(i, prevLVL);
            }
            prevLVL = (Integer)this.fontSize.get(i);
        }
        this.drawParts(gc, this.rootObject, 2, 0.0f);
        gc.setBackground(this.getDisplay().getSystemColor(1));
        gc.setAlpha(255);
        gc.fillOval(this.centerX - this.diameter / 2 - 3, this.centerY - this.diameter / 2 - 3, this.diameter + 6, this.diameter + 6);
        gc.setBackground(StatusDisplayInfo.getStatusColor((ObjectStatus)this.rootObject.getStatus()));
        gc.setAlpha(255);
        gc.fillOval(this.centerX - this.diameter / 2, this.centerY - this.diameter / 2, this.diameter, this.diameter);
        String text = this.rootObject instanceof AbstractNode ? this.rootObject.getNameWithAlias() + "\n" + ((AbstractNode)this.rootObject).getPrimaryIP().getHostAddress() : this.rootObject.getNameWithAlias();
        gc.setFont(this.valueFonts[(Integer)this.fontSize.get(0)]);
        gc.setClipping(rect);
        int h = gc.textExtent((String)text).y;
        int l = gc.textExtent((String)text).x;
        if (l + 6 >= this.diameter) {
            text = WidgetHelper.fitStringToArea((GC)gc, (String)text, (int)squareSide, (int)(squareSide / h)).getResult();
            h = gc.textExtent((String)text).y;
            l = gc.textExtent((String)text).x;
        }
        gc.setForeground(ColorConverter.selectTextColorByBackgroundColor((Color)StatusDisplayInfo.getStatusColor((ObjectStatus)this.rootObject.getStatus()), (ColorCache)this.cCache));
        gc.drawText(text, this.centerX - l / 2, this.centerY - h / 2, 3);
        this.objectMap.add(new ObjectPosition(this, 0.0f, 360.0f, 1, this.rootObject));
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (this.rootObject == null) {
            return super.computeSize(wHint, hHint, changed);
        }
        GC gc = new GC((Drawable)this.getDisplay());
        this.fitToScreen = wHint != -1 || hHint != -1;
        this.recalculateData(gc);
        gc.dispose();
        return this.fitToScreen ? new Point(Math.max(wHint, 240 * this.maxLvl), Math.max(hHint, 240 * this.maxLvl)) : new Point(this.diameter * (this.maxLvl + 1), this.diameter * (this.maxLvl + 1));
    }

    protected void updateObjects(AbstractObject rootObject, Collection<AbstractObject> objects) {
        this.rootObject = rootObject;
        this.objects.clear();
        for (AbstractObject o : objects) {
            this.objects.put(o.getObjectId(), new ObjectData(this, o));
        }
        this.redraw();
    }

    protected boolean containsObject(long id) {
        return this.rootObject.getObjectId() == id || this.objects.containsKey(id);
    }

    protected boolean containsChangedObject(AbstractObject object) {
        if (this.rootObject == null) {
            return false;
        }
        if (this.rootObject.getObjectId() == object.getObjectId()) {
            return true;
        }
        ObjectData d = (ObjectData)this.objects.get(object.getObjectId());
        return d != null ? d.isChanged(object) : false;
    }

    public AbstractObject getObjectFromPoint(int x, int y) {
        AbstractObject object = null;
        int clickLvl = (int)(Math.sqrt(Math.pow(x - this.centerX, 2.0) + Math.pow(y - this.centerY, 2.0)) / (double)(this.diameter / 2) + 1.0);
        double clickDegree = Math.toDegrees(Math.atan2(this.centerX - x, this.centerY - y));
        if ((clickDegree += 90.0) < 0.0) {
            clickDegree = 360.0 + clickDegree;
        }
        ObjectPosition curr = new ObjectPosition(this, (float)clickDegree, (float)clickDegree, clickLvl, null);
        for (ObjectPosition p : this.objectMap) {
            if (!p.equals((Object)curr)) continue;
            object = p.getObject();
            break;
        }
        return object;
    }
}

