/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.reporter.widgets.helpers;

import java.text.DateFormat;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.reporting.ReportResult;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.ui.eclipse.console.ViewerElementUpdater;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.reporter.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ReportResultLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private NXCSession session = ConsoleSharedData.getSession();
    private DateFormat dateFormat = RegionalSettings.getDateTimeFormat();
    private SortableTableViewer viewer;

    public ReportResultLabelProvider(SortableTableViewer viewer) {
        this.viewer = viewer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ReportResult reportResult = (ReportResult)element;
        switch (columnIndex) {
            case 0: {
                return this.dateFormat.format(reportResult.getExecutionTime());
            }
            case 1: {
                AbstractUserObject user = this.session.findUserDBObjectById(reportResult.getUserId(), (Runnable)new ViewerElementUpdater((ColumnViewer)this.viewer, element));
                return user != null ? user.getName() : "[" + reportResult.getUserId() + "]";
            }
            case 2: {
                String string;
                if (reportResult.isSuccess()) {
                    Messages.get();
                    string = Messages.ReportResultLabelProvider_Success;
                } else {
                    Messages.get();
                    string = Messages.ReportResultLabelProvider_Failure;
                }
                return string;
            }
        }
        return "<INTERNAL ERROR>";
    }
}

