/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.ui.eclipse.console.resources.ThemeEngine;
import org.netxms.ui.eclipse.tools.FontTools;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.DashboardComposite;
import org.netxms.ui.eclipse.widgets.helpers.DashboardElementButton;

public abstract class Card
extends DashboardComposite {
    private static final int HEADER_MARGIN_HEIGHT = 6;
    private static final int HEADER_MARGIN_WIDTH = 8;
    private static final int BOTTOM_MARGIN = 2;
    private String text;
    private Control clientArea;
    private Font titleFont;
    private Color titleBackground = null;
    private Color titleColor;
    private Point headerSize;
    private Action doubleClickAction = null;
    private List<DashboardElementButton> buttons = new ArrayList<DashboardElementButton>(0);

    public Card(Composite parent, String text) {
        super(parent, 2048);
        this.text = text;
        this.titleColor = ThemeEngine.getForegroundColor("Card.Title");
        this.titleFont = FontTools.createTitleFont();
        this.setFont(this.titleFont);
        this.headerSize = WidgetHelper.getTextExtent((Control)this, text);
        this.headerSize.y += 12 + this.getBorderWidth();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Card.this.titleFont.dispose();
            }
        });
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 3;
        layout.marginTop = this.headerSize.y;
        layout.marginBottom = 2;
        this.setLayout((Layout)layout);
        this.clientArea = this.createClientAreaInternal();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Card.this.doPaint(e.gc);
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (Card.this.doubleClickAction != null) {
                    Card.this.doubleClickAction.run();
                }
            }
        });
        this.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                Card.this.layoutButtons();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    private Control createClientAreaInternal() {
        Control ca = this.createClientArea((Composite)this);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        ca.setLayoutData((Object)gd);
        return ca;
    }

    protected void showClientArea(boolean show) {
        this.clientArea.setVisible(show);
        ((GridData)this.clientArea.getLayoutData()).exclude = !show;
        this.layout(true, true);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (!this.clientArea.isVisible()) {
            return new Point(wHint == -1 ? this.headerSize.x + 1 : wHint, hHint == -1 ? this.headerSize.y + 1 : hHint);
        }
        return super.computeSize(wHint, hHint, changed);
    }

    private void doPaint(GC gc) {
        Rectangle rect = this.getFullClientArea();
        gc.setAntialias(1);
        if (this.clientArea.isVisible()) {
            gc.setForeground(this.getBorderOuterColor());
            gc.drawLine(rect.x, this.headerSize.y, rect.x + rect.width, this.headerSize.y);
        }
        if (this.titleBackground != null) {
            rect = this.getClientArea();
            gc.setBackground(this.titleBackground);
            gc.fillRectangle(rect.x, rect.y, rect.width, this.headerSize.y - this.getBorderWidth() - 1);
        }
        gc.setForeground(this.titleColor);
        gc.drawText(this.text, 8, 6 + this.getBorderWidth(), 1);
    }

    protected abstract Control createClientArea(Composite var1);

    public boolean setFocus() {
        return this.clientArea.setFocus();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    protected Color getTitleBackground() {
        return this.titleBackground;
    }

    protected void setTitleBackground(Color backgroundColor) {
        this.titleBackground = backgroundColor;
        for (DashboardElementButton b : this.buttons) {
            b.getControl().setBackground(backgroundColor);
        }
    }

    protected Color getTitleColor() {
        return this.titleColor;
    }

    protected void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
    }

    public void addButton(final DashboardElementButton button) {
        Label l = new Label((Composite)this, 0);
        l.setBackground(this.getTitleBackground());
        l.setImage(button.getImage());
        l.setToolTipText(button.getName());
        l.setCursor(this.getDisplay().getSystemCursor(21));
        l.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                button.getAction().run();
            }
        });
        GridData gd = new GridData();
        gd.exclude = true;
        l.setLayoutData((Object)gd);
        button.setControl((Control)l);
        this.buttons.add(button);
        this.layoutButtons();
    }

    public void updateButtons() {
        for (DashboardElementButton b : this.buttons) {
            Label l = (Label)b.getControl();
            l.setImage(b.getImage());
            l.setToolTipText(b.getName());
        }
    }

    public Action getDoubleClickAction() {
        return this.doubleClickAction;
    }

    public void setDoubleClickAction(Action doubleClickAction) {
        this.doubleClickAction = doubleClickAction;
    }

    public void replaceClientArea() {
        if (this.clientArea != null) {
            this.clientArea.dispose();
        }
        this.clientArea = this.createClientAreaInternal();
        this.layout();
    }

    private void layoutButtons() {
        int pos = this.getSize().x - 8 - this.getBorderWidth();
        int i = this.buttons.size() - 1;
        while (i >= 0) {
            Control c = this.buttons.get(i).getControl();
            c.setSize(c.computeSize(-1, -1));
            Point cs = c.getSize();
            c.setLocation(pos - cs.x, this.headerSize.y / 2 - cs.y / 2);
            pos -= cs.x + 4;
            --i;
        }
    }
}

