/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.datacollection.DciValue;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.widgets.DciList;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class SelectNodeDciDialog
extends Dialog {
    private long nodeId;
    private DciList dciList;
    private List<DciValue> selection;
    private int dcObjectType = -1;

    public SelectNodeDciDialog(Shell parentShell, long nodeId) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.nodeId = nodeId;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.SelectNodeDciDialog_Title);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            newShell.setSize(settings.getInt("SelectDciDialog.width"), settings.getInt("SelectDciDialog.hight"));
            newShell.setLocation(settings.getInt("SelectDciDialog.cx"), settings.getInt("SelectDciDialog.cy"));
        }
        catch (NumberFormatException e) {
            newShell.setSize(400, 250);
            newShell.setLocation(100, 100);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new FillLayout());
        this.dciList = new DciList(null, dialogArea, 2048, null, "SelectNodeDciDialog.dciList", this.dcObjectType, 4, false);
        this.dciList.setDcObjectType(this.dcObjectType);
        this.dciList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectNodeDciDialog.this.okPressed();
            }
        });
        this.dciList.setNode(ConsoleSharedData.getSession().findObjectById(this.nodeId));
        return dialogArea;
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        Point pleace = this.getShell().getLocation();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("SelectDciDialog.cx", pleace.x);
        settings.put("SelectDciDialog.cy", pleace.y);
        settings.put("SelectDciDialog.width", size.x);
        settings.put("SelectDciDialog.hight", size.y);
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.selection = this.dciList.getSelection();
        if (this.selection == null || this.selection.size() == 0) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.SelectNodeDciDialog_Warning, (String)Messages.SelectNodeDciDialog_WarningText);
            return;
        }
        this.saveSettings();
        super.okPressed();
    }

    public DciValue getSelection() {
        if (this.selection.size() > 0) {
            return this.selection.get(0);
        }
        return null;
    }

    public int getDcObjectType() {
        return this.dcObjectType;
    }

    public void setDcObjectType(int dcObjectType) {
        this.dcObjectType = dcObjectType;
        if (this.dciList != null) {
            this.dciList.setDcObjectType(dcObjectType);
        }
    }
}

