/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum NetworkPathFailureReason {
    NONE(0),
    ROUTER_DOWN(1),
    SWITCH_DOWN(2),
    WIRELESS_AP_DOWN(3),
    PROXY_NODE_DOWN(4),
    PROXY_AGENT_UNREACHABLE(5),
    VPN_TUNNEL_DOWN(6),
    ROUTING_LOOP(7),
    INTERFACE_DISABLED(8);

    private static Logger logger;
    private static Map<Integer, NetworkPathFailureReason> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(NetworkPathFailureReason.class);
        lookupTable = new HashMap<Integer, NetworkPathFailureReason>();
        NetworkPathFailureReason[] networkPathFailureReasonArray = NetworkPathFailureReason.values();
        int n = networkPathFailureReasonArray.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkPathFailureReason element = networkPathFailureReasonArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private NetworkPathFailureReason(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static NetworkPathFailureReason getByValue(int value) {
        NetworkPathFailureReason element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return NONE;
        }
        return element;
    }
}

