/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RadioBand {
    UNKNOWN(0, "Unknown"),
    WIFI_2_4_GHZ(1, "2.4 GHz"),
    WIFI_3_65_GHZ(2, "3.65 GHz"),
    WIFI_5_GHZ(3, "5 GHz"),
    WIFI_6_GHZ(4, "6 GHz");

    private static Logger logger;
    private static Map<Integer, RadioBand> lookupTable;
    private int value;
    private String displayName;

    static {
        logger = LoggerFactory.getLogger(RadioBand.class);
        lookupTable = new HashMap<Integer, RadioBand>();
        RadioBand[] radioBandArray = RadioBand.values();
        int n = radioBandArray.length;
        int n2 = 0;
        while (n2 < n) {
            RadioBand element = radioBandArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private RadioBand(int value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.displayName;
    }

    public static RadioBand getByValue(int value) {
        RadioBand element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return UNKNOWN;
        }
        return element;
    }
}

