/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.NXCSession;
import org.netxms.client.topology.FdbEntry;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class FDBComparator
extends ViewerComparator {
    private NXCSession session = ConsoleSharedData.getSession();

    public int compare(Viewer viewer, Object e1, Object e2) {
        FdbEntry fdb1 = (FdbEntry)e1;
        FdbEntry fdb2 = (FdbEntry)e2;
        int result = switch ((Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID")) {
            case 3 -> fdb1.getInterfaceName().compareToIgnoreCase(fdb2.getInterfaceName());
            case 0 -> fdb1.getAddress().compareTo(fdb2.getAddress());
            case 1 -> this.getVendor(fdb1).compareTo(this.getVendor(fdb2));
            case 5 -> {
                String n1 = fdb1.getNodeId() != 0L ? this.session.getObjectName(fdb1.getNodeId()) : "";
                String n2 = fdb2.getNodeId() != 0L ? this.session.getObjectName(fdb2.getNodeId()) : "";
                yield n1.compareToIgnoreCase(n2);
            }
            case 2 -> fdb1.getPort() - fdb2.getPort();
            case 4 -> fdb1.getVlanId() - fdb2.getVlanId();
            case 6 -> fdb1.getType() - fdb2.getType();
            default -> 0;
        };
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }

    private String getVendor(FdbEntry entry) {
        String vendor = this.session.getVendorByMac(entry.getAddress(), null);
        return vendor != null ? vendor : "";
    }
}

