/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.dashboard.widgets.TitleConfigurator;
import org.netxms.ui.eclipse.dashboard.widgets.internal.RackDiagramConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.RackDisplayMode;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class RackDiagram
extends PropertyPage {
    private static final String[] RACK_DISPLAY_MODES = new String[]{"Full", "Front", "Back"};
    private RackDiagramConfig config;
    private ObjectSelector objectSelector;
    private TitleConfigurator title;
    private Combo displayMode;

    protected Control createContents(Composite parent) {
        this.config = (RackDiagramConfig)this.getElement().getAdapter(RackDiagramConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.objectSelector = new ObjectSelector(dialogArea, 0, false, true);
        this.objectSelector.setLabel("Rack");
        this.objectSelector.setClassFilter(ObjectSelectionDialog.createRackSelectionFilter());
        this.objectSelector.setObjectClass(AbstractObject.class);
        this.objectSelector.setObjectId(this.config.getObjectId());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.objectSelector.setLayoutData((Object)gd);
        this.title = new TitleConfigurator(dialogArea, this.config);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData(gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.displayMode = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Display mode", (Object)gd);
        this.displayMode.setItems(RACK_DISPLAY_MODES);
        this.displayMode.setText(RACK_DISPLAY_MODES[this.config.getDisplayMode().getValue()]);
        return dialogArea;
    }

    public boolean performOk() {
        this.title.updateConfiguration(this.config);
        this.config.setObjectId(this.objectSelector.getObjectId());
        this.config.setDisplayMode(RackDisplayMode.getByValue(this.displayMode.getSelectionIndex()));
        return true;
    }
}

