/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.agentmanagement.views.helpers;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.UserAgentNotification;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.ViewerElementUpdater;
import org.xnap.commons.i18n.I18n;

public class UserAgentNotificationLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final I18n i18n = LocalizationHelper.getI18n(UserAgentNotificationLabelProvider.class);
    private NXCSession session;
    private SortableTableViewer viewer;

    public UserAgentNotificationLabelProvider(SortableTableViewer viewer) {
        this.viewer = viewer;
        this.session = Registry.getSession();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        UserAgentNotification uaMessage = (UserAgentNotification)element;
        switch (columnIndex) {
            case 0: {
                return Long.toString(uaMessage.getId());
            }
            case 1: {
                return uaMessage.getObjectNames();
            }
            case 2: {
                return uaMessage.getMessage();
            }
            case 3: {
                return uaMessage.isRecalled() ? this.i18n.tr("Yes") : this.i18n.tr("No");
            }
            case 4: {
                return uaMessage.isStartupNotification() ? this.i18n.tr("Yes") : this.i18n.tr("No");
            }
            case 5: {
                return uaMessage.getStartTime().getTime() == 0L ? "" : DateFormatFactory.getDateTimeFormat().format(uaMessage.getStartTime());
            }
            case 6: {
                return uaMessage.getEndTime().getTime() == 0L ? "" : DateFormatFactory.getDateTimeFormat().format(uaMessage.getEndTime());
            }
            case 7: {
                return uaMessage.getCreationTime().getTime() == 0L ? "" : DateFormatFactory.getDateTimeFormat().format(uaMessage.getCreationTime());
            }
            case 8: {
                return this.getUserName(uaMessage);
            }
        }
        return null;
    }

    public String getUserName(UserAgentNotification n) {
        AbstractUserObject user = this.session.findUserDBObjectById(n.getCreatedBy(), (Runnable)new ViewerElementUpdater((ColumnViewer)this.viewer, (Object)n));
        return user != null ? user.getName() : "[" + Long.toString(n.getCreatedBy()) + "]";
    }
}

