/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.widgets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.AgentPolicy;
import org.netxms.nxmc.modules.datacollection.views.PolicyEditorView;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.PolicyModifyListener;

public abstract class AbstractPolicyEditor
extends Composite {
    protected AgentPolicy policy;
    protected PolicyEditorView view;
    private Set<PolicyModifyListener> listeners = new HashSet();
    private boolean enableModifyListeners = true;

    public AbstractPolicyEditor(Composite parent, int style, AgentPolicy policy, PolicyEditorView view) {
        super(parent, style);
        this.policy = policy;
        this.view = view;
    }

    public void addModifyListener(PolicyModifyListener modifyListener) {
        this.listeners.add(modifyListener);
    }

    public void removeModifyListener(PolicyModifyListener modifyListener) {
        this.listeners.remove(modifyListener);
    }

    protected void fireModifyListeners() {
        if (this.enableModifyListeners) {
            for (PolicyModifyListener l : this.listeners) {
                l.modifyParser();
            }
        }
    }

    public void setPolicy(AgentPolicy policy) {
        this.policy = policy;
        this.enableModifyListeners = false;
        this.updateControlFromPolicy();
        this.enableModifyListeners = true;
    }

    public abstract void updateControlFromPolicy();

    public abstract void updatePolicyFromControl();

    public void fillLocalPullDown(IMenuManager manager) {
    }

    public void fillLocalToolBar(IToolBarManager manager) {
    }

    public String isSaveAllowed() {
        return null;
    }

    public void onSave() {
    }

    public void onDiscard() {
    }
}

