/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.InetAddressEx;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class AddSubnetDialog
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(AddSubnetDialog.class);
    private LabeledText address;
    private LabeledSpinner mask;
    private InetAddressEx subnet;

    public AddSubnetDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Add Subnet"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.address = new LabeledText(dialogArea, 0);
        this.address.setLabel(this.i18n.tr("Network address"));
        this.address.setText("0.0.0.0");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.address.setLayoutData((Object)gd);
        this.mask = new LabeledSpinner(dialogArea, 0);
        this.mask.setLabel(this.i18n.tr("Network mask"));
        this.mask.getSpinnerControl().setMinimum(0);
        this.mask.getSpinnerControl().setMaximum(128);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.mask.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        try {
            InetAddress a = InetAddress.getByName(this.address.getText().trim());
            this.subnet = new InetAddressEx(a, this.mask.getSelection());
        }
        catch (UnknownHostException e) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Address validation error"));
            return;
        }
        super.okPressed();
    }

    public InetAddressEx getSubnet() {
        return this.subnet;
    }
}

