/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.SharedIcons;
import org.xnap.commons.i18n.I18n;

public class NetworkMapPublicAccessDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(NetworkMapPublicAccessDialog.class);
    private String token;
    private String url;

    public NetworkMapPublicAccessDialog(Shell parentShell, String token, String url) {
        super(parentShell);
        this.token = token;
        this.url = url;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Map Public Access Details"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        LabeledText tokenText = new LabeledText(dialogArea, 0, 2056);
        tokenText.setLabel("Access token");
        tokenText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        tokenText.setText(this.token);
        Button copyButton = new Button(dialogArea, 8);
        copyButton.setBackground(dialogArea.getBackground());
        copyButton.setImage(SharedIcons.IMG_COPY_TO_CLIPBOARD);
        copyButton.setToolTipText(this.i18n.tr("Copy token to clipboard"));
        GridData gd = new GridData();
        gd.verticalAlignment = 1024;
        copyButton.setLayoutData((Object)gd);
        copyButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        LabeledText urlText = new LabeledText(dialogArea, 0, 2056);
        urlText.setLabel(this.i18n.tr("Direct access URL"));
        gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 600;
        urlText.setLayoutData((Object)gd);
        urlText.setText(this.url);
        Button copyUrlButton = new Button(dialogArea, 8);
        copyUrlButton.setBackground(dialogArea.getBackground());
        copyUrlButton.setImage(SharedIcons.IMG_COPY_TO_CLIPBOARD);
        copyUrlButton.setToolTipText(this.i18n.tr("Copy URL to clipboard"));
        gd = new GridData();
        gd.verticalAlignment = 1024;
        copyUrlButton.setLayoutData((Object)gd);
        copyUrlButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, this.i18n.tr("Close"), false);
    }
}

