/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.base.actions.CopyTableRowsAction;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.helpers.ArpCacheComparator;
import org.netxms.nxmc.modules.objects.views.helpers.ArpCacheFilter;
import org.netxms.nxmc.modules.objects.views.helpers.ArpCacheLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class ArpCacheView
extends ObjectView {
    private final I18n i18n = LocalizationHelper.getI18n(ArpCacheView.class);
    public static final int COLUMN_IP_ADDRESS = 0;
    public static final int COLUMN_MAC_ADDRESS = 1;
    public static final int COLUMN_VENDOR = 2;
    public static final int COLUMN_INTERFACE = 3;
    public static final int COLUMN_NODE = 4;
    private SortableTableViewer viewer;
    private boolean refreshPending = true;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;
    private Action actionCopyRowToClipboard;
    private Action actionCopyMACToClipboard;

    public ArpCacheView() {
        super(LocalizationHelper.getI18n(ArpCacheView.class).tr("ARP Cache"), ResourceManager.getImageDescriptor((String)"icons/object-views/fdb.gif"), "objects.arp-cache", true);
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof Node && (((Node)context).hasAgent() || ((Node)context).hasSnmpAgent() || ((Node)context).isManagementServer());
    }

    public int getPriority() {
        return 155;
    }

    protected void createContent(Composite parent) {
        String[] names = new String[]{this.i18n.tr("IP Address"), this.i18n.tr("MAC Address"), this.i18n.tr("NIC Vendor"), this.i18n.tr("Interface"), this.i18n.tr("Node")};
        int[] widths = new int[]{180, 180, 200, 200, 250};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 1024, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ArpCacheLabelProvider((TableViewer)this.viewer));
        this.viewer.setComparator((ViewerComparator)new ArpCacheComparator());
        ArpCacheFilter filter = new ArpCacheFilter();
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)filter);
        this.viewer.addFilter((ViewerFilter)filter);
        this.createActions();
        this.createPopupMenu();
    }

    private void createActions() {
        this.actionCopyRowToClipboard = new CopyTableRowsAction((ColumnViewer)this.viewer, true);
        this.actionCopyMACToClipboard = new /* Unavailable Anonymous Inner Class!! */;
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, true);
        this.actionExportAllToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, false);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopyRowToClipboard);
        manager.add((IAction)this.actionCopyMACToClipboard);
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IAction)this.actionExportAllToCsv);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
    }

    public void refresh() {
        long objectId = this.getObjectId();
        if (objectId == 0L) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void activate() {
        super.activate();
        if (this.refreshPending) {
            this.refreshPending = false;
            this.refresh();
        }
    }

    protected void onObjectChange(AbstractObject object) {
        this.viewer.setInput((Object)new Object[0]);
        if (this.isActive()) {
            this.refresh();
        } else {
            this.refreshPending = true;
        }
    }
}

