/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.users.propertypages;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.base.widgets.FilterText;
import org.netxms.nxmc.base.widgets.MessageAreaHolder;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.users.dialogs.CustomAttributeEditDialog;
import org.netxms.nxmc.modules.users.propertypages.CustomAttributes;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class CustomAttributes
extends PropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(CustomAttributes.class);
    private NXCSession session = Registry.getSession();
    private AbstractUserObject object;
    private Map<String, String> attributes;
    private String filterText = "";
    private FilterText filter;
    private SortableTableViewer viewer;

    public CustomAttributes(AbstractUserObject object, MessageAreaHolder messageArea) {
        super(LocalizationHelper.getI18n(CustomAttributes.class).tr("Custom Attributes"), messageArea);
        this.object = object;
        this.attributes = new HashMap(object.getCustomAttributes());
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        Composite listArea = new Composite(dialogArea, 2048);
        listArea.setBackground(parent.getDisplay().getSystemColor(25));
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        listArea.setLayout((Layout)layout);
        this.filter = new FilterText(listArea, 0, null, false, false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.filter.setLayoutData((Object)gd);
        this.filter.setBackground(parent.getDisplay().getSystemColor(25));
        this.filter.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        String[] columnNames = new String[]{this.i18n.tr("Name"), this.i18n.tr("Value")};
        int[] columnWidths = new int[]{150, 250};
        this.viewer = new SortableTableViewer(listArea, columnNames, columnWidths, 0, 128, 65538);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 400;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AttributeListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addFilter((ViewerFilter)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.setInput(this.attributes.entrySet());
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        Button addButton = new Button(buttons, 8);
        addButton.setText(this.i18n.tr("&Add..."));
        RowData rd = new RowData();
        rd.width = 90;
        addButton.setLayoutData((Object)rd);
        addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button editButton = new Button(buttons, 8);
        editButton.setText(this.i18n.tr("&Modify..."));
        rd = new RowData();
        rd.width = 90;
        editButton.setLayoutData((Object)rd);
        editButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button deleteButton = new Button(buttons, 8);
        deleteButton.setText(this.i18n.tr("&Delete"));
        rd = new RowData();
        rd.width = 90;
        deleteButton.setLayoutData((Object)rd);
        deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    private void addAttribute() {
        CustomAttributeEditDialog dlg = new CustomAttributeEditDialog(this.getShell(), null, null);
        if (dlg.open() != 0) {
            return;
        }
        if (this.attributes.containsKey(dlg.getName())) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)String.format(this.i18n.tr("Attribute named %s already exists"), dlg.getName()));
        } else {
            this.attributes.put(dlg.getName(), dlg.getValue());
            this.viewer.refresh();
        }
    }

    private void editAttribute() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        Map.Entry element = (Map.Entry)selection.getFirstElement();
        CustomAttributeEditDialog dlg = new CustomAttributeEditDialog(this.getShell(), (String)element.getKey(), (String)element.getValue());
        if (dlg.open() != 0) {
            return;
        }
        if (((String)element.getKey()).equals(dlg.getName())) {
            this.attributes.put(dlg.getName(), dlg.getValue());
        } else if (this.attributes.containsKey(dlg.getName())) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)String.format(this.i18n.tr("Attribute named %s already exists"), dlg.getName()));
        } else {
            this.attributes.remove(element.getKey());
            this.attributes.put(dlg.getName(), dlg.getValue());
        }
        this.viewer.refresh();
    }

    private void deleteAttributes() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        HashSet<String> keys = new HashSet<String>();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            keys.add((String)((Map.Entry)it.next()).getKey());
        }
        for (String k : keys) {
            this.attributes.remove(k);
        }
        this.viewer.refresh();
    }

    protected boolean applyChanges(boolean isApply) {
        if (isApply) {
            this.setMessage(null);
            this.setValid(false);
        }
        this.object.setCustomAttributes(this.attributes);
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }
}

