/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.users.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.users.views.helpers.DecoratingUserLabelProvider;
import org.xnap.commons.i18n.I18n;

public final class UserFilter
extends ViewerFilter {
    private final I18n i18n = LocalizationHelper.getI18n(UserFilter.class);
    private String filterString;
    private DecoratingUserLabelProvider labelProvider;

    public UserFilter(DecoratingUserLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        String objType;
        if (this.filterString == null || this.filterString.isEmpty()) {
            return true;
        }
        AbstractUserObject user = (AbstractUserObject)element;
        boolean found = false;
        if (element instanceof User) {
            String authMethod = "";
            try {
                authMethod = DecoratingUserLabelProvider.AUTH_METHOD[((User)user).getAuthMethod().getValue()];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                authMethod = this.i18n.tr("Unknown");
            }
            if (authMethod.toLowerCase().contains(this.filterString) || ((User)user).getFullName().toLowerCase().contains(this.filterString)) {
                return true;
            }
        }
        String objClass = element instanceof User ? this.i18n.tr("User") : this.i18n.tr("Group");
        String string = objType = (user.getFlags() & 0x80) != 0 ? this.i18n.tr("LDAP") : this.i18n.tr("Local");
        if (objClass.toLowerCase().contains(this.filterString) || objType.toLowerCase().contains(this.filterString) || user.getName().toLowerCase().contains(this.filterString) || user.getDescription().toLowerCase().contains(this.filterString) || user.getLdapDn().toLowerCase().contains(this.filterString)) {
            found = true;
        }
        return found;
    }

    public void setFilterString(String text) {
        this.filterString = text.trim().toLowerCase();
    }

    public String getFilterString() {
        return this.filterString;
    }
}

