/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import com.google.gson.Gson;
import org.eclipse.ui.IViewPart;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.ui.eclipse.charts.api.ChartType;
import org.netxms.ui.eclipse.charts.widgets.Chart;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ScriptedComparisonChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.internal.ScriptedBarChartConfig;

public class ScriptedBarChartElement
extends ScriptedComparisonChartElement {
    private ScriptedBarChartConfig elementConfig;

    public ScriptedBarChartElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.elementConfig = (ScriptedBarChartConfig)new Gson().fromJson(element.getData(), ScriptedBarChartConfig.class);
        }
        catch (Exception e) {
            Activator.logError((String)"Cannot parse dashboard element configuration", (Throwable)e);
            this.elementConfig = new ScriptedBarChartConfig();
        }
        this.processCommonSettings(this.elementConfig);
        this.script = this.elementConfig.getScript();
        this.objectId = this.getEffectiveObjectId(this.elementConfig.getObjectId());
        this.refreshInterval = this.elementConfig.getRefreshRate();
        ChartConfiguration chartConfig = new ChartConfiguration();
        chartConfig.setTitleVisible(false);
        chartConfig.setLegendPosition(this.elementConfig.getLegendPosition());
        chartConfig.setLegendVisible(this.elementConfig.isShowLegend());
        chartConfig.setExtendedLegend(this.elementConfig.isExtendedLegend());
        chartConfig.setTransposed(this.elementConfig.isTransposed());
        chartConfig.setTranslucent(this.elementConfig.isTranslucent());
        chartConfig.setAutoScale(this.elementConfig.isAutoScale());
        chartConfig.setMinYScaleValue(this.elementConfig.getMinYScaleValue());
        chartConfig.setMaxYScaleValue(this.elementConfig.getMaxYScaleValue());
        this.chart = new Chart(this.getContentArea(), 0, ChartType.BAR, chartConfig);
        this.chart.setDrillDownObjectId(this.elementConfig.getDrillDownObjectId());
        this.chart.rebuild();
        this.startRefreshTimer();
    }
}

