/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OSPFInterfaceState {
    UNKNOWN(0, ""),
    DOWN(1, "DOWN"),
    LOOPBACK(2, "LOOPBACK"),
    WAITING(3, "WAITING"),
    POINT_TO_POINT(4, "PT-TO-PT"),
    DESIGNATED_ROUTER(5, "DR"),
    BACKUP_DESIGNATED_ROUTER(6, "BDR"),
    OTHER_DESIGNATED_ROUTER(7, "ODR");

    private static Logger logger;
    private static Map<Integer, OSPFInterfaceState> lookupTable;
    private int value;
    private String text;

    static {
        logger = LoggerFactory.getLogger(OSPFInterfaceState.class);
        lookupTable = new HashMap<Integer, OSPFInterfaceState>();
        OSPFInterfaceState[] oSPFInterfaceStateArray = OSPFInterfaceState.values();
        int n = oSPFInterfaceStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            OSPFInterfaceState element = oSPFInterfaceStateArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private OSPFInterfaceState(int value, String text) {
        this.value = value;
        this.text = text;
    }

    public int getValue() {
        return this.value;
    }

    public String getText() {
        return this.text;
    }

    public static OSPFInterfaceState getByValue(int value) {
        OSPFInterfaceState element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return UNKNOWN;
        }
        return element;
    }
}

