/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps.elements;

import com.google.gson.Gson;
import org.netxms.base.NXCPMessage;
import org.netxms.client.maps.configs.TextBoxConfig;
import org.netxms.client.maps.elements.NetworkMapElement;

public class NetworkMapTextBox
extends NetworkMapElement {
    private String text;
    private int backgroundColor;
    private int textColor;
    private int borderColor;
    private int fontSize;
    private long drillDownObjectId;
    private boolean borderRequired;

    protected NetworkMapTextBox(NXCPMessage msg, long baseId) {
        super(msg, baseId);
        String json = msg.getFieldAsString(baseId + 10L);
        try {
            TextBoxConfig config = (TextBoxConfig)new Gson().fromJson(json, TextBoxConfig.class);
            this.text = config.getText();
            this.backgroundColor = config.getBackgroundColor();
            this.textColor = config.getTextColor();
            this.borderColor = config.getBorderColor();
            this.borderRequired = config.isBorderRequired();
            this.fontSize = config.getFontSize();
            this.drillDownObjectId = config.getDrillDownObjectId();
        }
        catch (Exception e) {
            this.text = "";
            this.backgroundColor = Integer.MAX_VALUE;
            this.textColor = 0;
            this.borderColor = 0;
            this.borderRequired = true;
            this.fontSize = 10;
            this.drillDownObjectId = 0L;
        }
        this.type = 5;
    }

    public NetworkMapTextBox(long id) {
        super(id);
        this.text = "";
        this.backgroundColor = Integer.MAX_VALUE;
        this.textColor = 0;
        this.borderColor = 0;
        this.borderRequired = true;
        this.fontSize = 10;
        this.type = 5;
    }

    @Override
    public void fillMessage(NXCPMessage msg, long baseId) {
        super.fillMessage(msg, baseId);
        TextBoxConfig config = new TextBoxConfig();
        config.setText(this.text);
        config.setBackgroundColor(this.backgroundColor);
        config.setTextColor(this.textColor);
        config.setBorderColor(this.borderColor);
        config.setBorderRequired(this.borderRequired);
        config.setFontSize(this.fontSize);
        config.setDrillDownObjectId(this.drillDownObjectId);
        msg.setFieldJson(baseId + 10L, (Object)config);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
    }

    public boolean isBorderRequired() {
        return this.borderRequired;
    }

    public void setBorderRequired(boolean borderRequired) {
        this.borderRequired = borderRequired;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public long getDrillDownObjectId() {
        return this.drillDownObjectId;
    }

    public void setDrillDownObjectId(long drillDownObjectId) {
        this.drillDownObjectId = drillDownObjectId;
    }
}

