/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class MQTT
extends PropertyPage {
    private AbstractNode node;
    private ObjectSelector mqttProxy;
    private NXCSession session;

    protected Control createContents(Composite parent) {
        this.node = (AbstractNode)this.getElement().getAdapter(AbstractNode.class);
        this.session = ConsoleSharedData.getSession();
        Composite dialogArea = new Composite(parent, 0);
        GridLayout dialogLayout = new GridLayout();
        dialogLayout.marginWidth = 0;
        dialogLayout.marginHeight = 0;
        dialogLayout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)dialogLayout);
        this.mqttProxy = new ObjectSelector(dialogArea, 0, true);
        this.mqttProxy.setLabel("Proxy");
        this.mqttProxy.setEmptySelectionName("<default>");
        this.mqttProxy.setObjectId(this.node.getMqttProxyId());
        this.mqttProxy.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        return dialogArea;
    }

    protected boolean applyChanges(final boolean isApply) {
        final NXCObjectModificationData md = new NXCObjectModificationData(this.node.getObjectId());
        if (isApply) {
            this.setValid(false);
        }
        md.setMqttProxy(this.mqttProxy.getObjectId());
        new ConsoleJob(String.format("Updating MQTT settings for object %s", this.node.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                MQTT.this.session.modifyObject(md);
            }

            protected String getErrorMessage() {
                return String.format("Cannot update MQTT settings for object %s", MQTT.this.node.getObjectName());
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            MQTT.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.mqttProxy.setObjectId(0L);
    }
}

