/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.reports.acl;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.netxms.client.AccessListElement;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.client.users.UserGroup;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.usermanager.reports.acl.constants.GroupsSheetCells;
import org.netxms.ui.eclipse.usermanager.reports.acl.constants.PermissionsSheetCells;
import org.netxms.ui.eclipse.usermanager.reports.acl.constants.UsersSheetCells;

public class AclReport {
    private final String SHEET_USERS = "Users";
    private final String SHEET_GROUPS = "Groups";
    private final String SHEET_PERMISSIONS = "Object Permissions";
    private NXCSession session = ConsoleSharedData.getSession();
    private String outputFileName;

    public AclReport(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public void execute() throws IOException, NXCException {
        ArrayList<ObjectAccess> permissions = new ArrayList<ObjectAccess>();
        AbstractObject[] topLevelObjects = this.session.getTopLevelObjects();
        Object object = topLevelObjects;
        int n = topLevelObjects.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractObject topLevelObject = object[n2];
            AclReport.scanACL(topLevelObject, "", permissions);
            ++n2;
        }
        for (ObjectAccess row : permissions) {
            AbstractUserObject user = this.session.findUserDBObjectById(row.userId, null);
            if (user != null) {
                row.userName = user.getName();
                if (user instanceof User) continue;
                row.userName = String.valueOf(row.userName) + " (group)";
                continue;
            }
            row.userName = String.format("DELETED [%d]", row.userId);
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFFont headerFont = wb.createFont();
        headerFont.setBold(true);
        HSSFCellStyle headerCellStyle = wb.createCellStyle();
        headerCellStyle.setFont(headerFont);
        wb.createSheet();
        wb.createSheet();
        wb.createSheet();
        wb.setSheetName(0, "Users");
        wb.setSheetName(1, "Groups");
        wb.setSheetName(2, "Object Permissions");
        this.generateUserSheet(wb, headerCellStyle);
        this.generateGroupsSheet(wb, headerCellStyle);
        this.generatePermissionsSheet(wb, headerCellStyle, permissions);
        object = null;
        Object var7_11 = null;
        try (FileOutputStream fileOut = new FileOutputStream(this.outputFileName);){
            wb.write((OutputStream)fileOut);
            ((OutputStream)fileOut).close();
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }

    private void generateUserSheet(HSSFWorkbook wb, HSSFCellStyle headerStyle) {
        AtomicInteger rowNum = new AtomicInteger(0);
        HSSFSheet sheet = wb.getSheet("Users");
        HSSFRow headerRow = sheet.createRow(rowNum.getAndIncrement());
        HSSFCell cell = headerRow.createCell(UsersSheetCells.ID.ordinal());
        cell.setCellValue("ID");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.LOGIN.ordinal());
        cell.setCellValue("Login");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.STATUS.ordinal());
        cell.setCellValue("Status");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.FULL_NAME.ordinal());
        cell.setCellValue("Full Name");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.DESCRIPTION.ordinal());
        cell.setCellValue("Description");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.ORIGIN.ordinal());
        cell.setCellValue("Origin");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.GROUPS.ordinal());
        cell.setCellValue("Member of");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.ALL_SCHEDULED_TASKS.ordinal());
        cell.setCellValue("All Scheduled tasks");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.AM_ATTRIBUTE_MANAGE.ordinal());
        cell.setCellValue("Asset Mgmt Attributes");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.CONFIGURE_TRAPS.ordinal());
        cell.setCellValue("SNMP Traps");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.DELETE_ALARMS.ordinal());
        cell.setCellValue("Delete Alarms");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.EDIT_EVENT_DB.ordinal());
        cell.setCellValue("Event Templates");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.EPP.ordinal());
        cell.setCellValue("EPP");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.EXTERNAL_INTEGRATION.ordinal());
        cell.setCellValue("External Integration");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.IMPORT_CONFIGURATION.ordinal());
        cell.setCellValue("Import Config");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.MANAGE_ACTIONS.ordinal());
        cell.setCellValue("Manage Actions");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.MANAGE_AGENT_CFG.ordinal());
        cell.setCellValue("Managet Agent Configs");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.MANAGE_GEO_AREAS.ordinal());
        cell.setCellValue("Manage Geo Areas");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.MANAGE_IMAGE_LIB.ordinal());
        cell.setCellValue("Manage Image Library");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.MANAGE_MAPPING_TBLS.ordinal());
        cell.setCellValue("Manage Mapping Tables");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.MANAGE_OBJECT_QUERIES.ordinal());
        cell.setCellValue("Manage Object Queries");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.MANAGE_PACKAGES.ordinal());
        cell.setCellValue("Manage Packages");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.MANAGE_REPOSITORIES.ordinal());
        cell.setCellValue("Manage Repositories");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.MANAGE_SCRIPTS.ordinal());
        cell.setCellValue("Manage Scripts");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.MANAGE_SERVER_FILES.ordinal());
        cell.setCellValue("Manage Server Files");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.MANAGE_SESSIONS.ordinal());
        cell.setCellValue("Manage Sessions");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.MANAGE_SUMMARY_TBLS.ordinal());
        cell.setCellValue("Manage Summary Tables");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.MANAGE_TOOLS.ordinal());
        cell.setCellValue("Manage Tools");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.MANAGE_2FA_METHODS.ordinal());
        cell.setCellValue("Manage 2FA Methods");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.MANAGE_USERS.ordinal());
        cell.setCellValue("Manage Users");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.MOBILE_DEVICE_LOGIN.ordinal());
        cell.setCellValue("Manage Device Login");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.OBJECT_CATEGORIES.ordinal());
        cell.setCellValue("Object Categories");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.OWN_SCHEDULED_TASKS.ordinal());
        cell.setCellValue("Own Scheduled Tasks");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.PERSISTENT_STORAGE.ordinal());
        cell.setCellValue("Persistent Storage");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.READ_SERVER_FILES.ordinal());
        cell.setCellValue("Read Server Files");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.REGISTER_AGENTS.ordinal());
        cell.setCellValue("Register Agents");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.REPORTING_SERVER.ordinal());
        cell.setCellValue("Reporting Server");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.SCHEDULE_FILE_UPLOAD.ordinal());
        cell.setCellValue("Schedule File Upload");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.SCHEDULE_MAINTENANCE.ordinal());
        cell.setCellValue("Schedule Maintenance");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.SCHEDULE_SCRIPT.ordinal());
        cell.setCellValue("Schedule Scripts");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.SEND_NOTIFICATION.ordinal());
        cell.setCellValue("Send Notifications");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.SERVER_CONFIG.ordinal());
        cell.setCellValue("Server Config");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.SERVER_CONSOLE.ordinal());
        cell.setCellValue("Server Console");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.SETUP_TCP_PROXY.ordinal());
        cell.setCellValue("Setup TCP Proxy");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.SSH_KEY_CONFIGURATION.ordinal());
        cell.setCellValue("SSH Keys");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.UA_NOTIFICATIONS.ordinal());
        cell.setCellValue("User Agent Notifications");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.UNLINK_ISSUES.ordinal());
        cell.setCellValue("Unlink Issues");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.USER_SCHEDULED_TASKS.ordinal());
        cell.setCellValue("User Scheduled Tasks");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.VIEW_ALL_ALARMS.ordinal());
        cell.setCellValue("Vikew All Alarms");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.VIEW_ASSET_CHANGE_LOG.ordinal());
        cell.setCellValue("Asset Change Log");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.VIEW_AUDIT_LOG.ordinal());
        cell.setCellValue("Audit Log");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.VIEW_EVENT_DB.ordinal());
        cell.setCellValue("View Event Templates");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.VIEW_EVENT_LOG.ordinal());
        cell.setCellValue("Event Log");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.VIEW_REPOSITORIES.ordinal());
        cell.setCellValue("View Repositories");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.VIEW_SYSLOG.ordinal());
        cell.setCellValue("Syslog");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.VIEW_TRAP_LOG.ordinal());
        cell.setCellValue("SNMP Trap Log");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.WEB_SERVICE_DEFINITIONS.ordinal());
        cell.setCellValue("Web Service Definitions");
        cell.setCellStyle(headerStyle);
        sheet.setColumnWidth(UsersSheetCells.ID.ordinal(), 2048);
        sheet.setColumnWidth(UsersSheetCells.LOGIN.ordinal(), 3072);
        sheet.setColumnWidth(UsersSheetCells.STATUS.ordinal(), 2048);
        sheet.setColumnWidth(UsersSheetCells.FULL_NAME.ordinal(), 6144);
        sheet.setColumnWidth(UsersSheetCells.DESCRIPTION.ordinal(), 6144);
        sheet.setColumnWidth(UsersSheetCells.ORIGIN.ordinal(), 2048);
        sheet.setColumnWidth(UsersSheetCells.GROUPS.ordinal(), 6144);
        AbstractUserObject[] userDatabaseObjects = this.session.getUserDatabaseObjects();
        Arrays.stream(userDatabaseObjects).filter(p -> p instanceof User).sorted(Comparator.comparing(AbstractUserObject::getName)).forEach(element -> {
            User user = (User)element;
            HSSFRow row = sheet.createRow(rowNum.getAndIncrement());
            row.createCell(UsersSheetCells.ID.ordinal()).setCellValue((double)user.getId());
            row.createCell(UsersSheetCells.LOGIN.ordinal()).setCellValue(user.getName());
            row.createCell(UsersSheetCells.STATUS.ordinal()).setCellValue(user.isDisabled() ? "Disabled" : "Active");
            row.createCell(UsersSheetCells.FULL_NAME.ordinal()).setCellValue(user.getFullName());
            row.createCell(UsersSheetCells.DESCRIPTION.ordinal()).setCellValue(user.getDescription());
            row.createCell(UsersSheetCells.ORIGIN.ordinal()).setCellValue((user.getFlags() & 0x80) != 0 ? "LDAP" : "Local");
            boolean firstRow = true;
            int[] nArray = user.getGroups();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                HSSFRow groupRow;
                int groupId = nArray[n2];
                if (firstRow) {
                    groupRow = row;
                    firstRow = false;
                } else {
                    groupRow = sheet.createRow(rowNum.getAndIncrement());
                }
                AbstractUserObject group = this.session.findUserDBObjectById(groupId, null);
                groupRow.createCell(UsersSheetCells.GROUPS.ordinal()).setCellValue(group.getName());
                ++n2;
            }
            this.createPermissionCell(row, UsersSheetCells.ALL_SCHEDULED_TASKS, 0x100000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.AM_ATTRIBUTE_MANAGE, 0x2000000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.CONFIGURE_TRAPS, 4L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.DELETE_ALARMS, 256L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.EDIT_EVENT_DB, 32L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.EPP, 64L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.EXTERNAL_INTEGRATION, 0x8000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.IMPORT_CONFIGURATION, 0x20000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.MANAGE_ACTIONS, 128L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.MANAGE_AGENT_CFG, 32768L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.MANAGE_GEO_AREAS, 0x200000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.MANAGE_IMAGE_LIB, 0x8000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.MANAGE_MAPPING_TBLS, 0x800000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.MANAGE_OBJECT_QUERIES, 0x800000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.MANAGE_PACKAGES, 512L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.MANAGE_REPOSITORIES, 0x1000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.MANAGE_SCRIPTS, 4096L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.MANAGE_SERVER_FILES, 0x400000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.MANAGE_SESSIONS, 8L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.MANAGE_SUMMARY_TBLS, 0x1000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.MANAGE_TOOLS, 2048L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.MANAGE_2FA_METHODS, 0x1000000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.MANAGE_USERS, 1L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.MOBILE_DEVICE_LOGIN, 262144L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.OBJECT_CATEGORIES, 0x100000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.OWN_SCHEDULED_TASKS, 0x80000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.PERSISTENT_STORAGE, 65536L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.READ_SERVER_FILES, 0x100000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.REGISTER_AGENTS, 524288L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.REPORTING_SERVER, 0x2000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.SCHEDULE_FILE_UPLOAD, 0x400000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.SCHEDULE_MAINTENANCE, 0x800000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.SCHEDULE_SCRIPT, 0x200000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.SEND_NOTIFICATION, 131072L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.SERVER_CONFIG, 2L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.SERVER_CONSOLE, 0x200000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.SETUP_TCP_PROXY, 0x10000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.SSH_KEY_CONFIGURATION, 0x400000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.UA_NOTIFICATIONS, 0x40000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.UNLINK_ISSUES, 0x10000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.USER_SCHEDULED_TASKS, 0x40000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.VIEW_ALL_ALARMS, 0x4000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.VIEW_ASSET_CHANGE_LOG, 0x4000000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.VIEW_AUDIT_LOG, 16384L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.VIEW_EVENT_DB, 16L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.VIEW_EVENT_LOG, 1024L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.VIEW_REPOSITORIES, 0x2000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.VIEW_SYSLOG, 0x20000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.VIEW_TRAP_LOG, 8192L, (AbstractUserObject)user);
            this.createPermissionCell(row, UsersSheetCells.WEB_SERVICE_DEFINITIONS, 0x80000000000L, (AbstractUserObject)user);
        });
    }

    private void createPermissionCell(HSSFRow row, UsersSheetCells cellId, long accessBit, AbstractUserObject userObject) {
        row.createCell(cellId.ordinal()).setCellValue((userObject.getSystemRights() & accessBit) != 0L ? "YES" : "NO");
    }

    private void generateGroupsSheet(HSSFWorkbook wb, HSSFCellStyle headerStyle) {
        AtomicInteger rowNum = new AtomicInteger(0);
        HSSFSheet sheet = wb.getSheet("Groups");
        HSSFRow headerRow = sheet.createRow(rowNum.getAndIncrement());
        HSSFCell cell = headerRow.createCell(GroupsSheetCells.ID.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("ID");
        cell = headerRow.createCell(GroupsSheetCells.NAME.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Name");
        cell = headerRow.createCell(GroupsSheetCells.DESCRIPTION.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Description");
        cell = headerRow.createCell(GroupsSheetCells.MEMBERS.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Members");
        cell = headerRow.createCell(GroupsSheetCells.ALL_SCHEDULED_TASKS.ordinal());
        cell.setCellValue("All Scheduled tasks");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.AM_ATTRIBUTE_MANAGE.ordinal());
        cell.setCellValue("Asset Mgmt Attributes");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.CONFIGURE_TRAPS.ordinal());
        cell.setCellValue("Configure SNMP Traps");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.DELETE_ALARMS.ordinal());
        cell.setCellValue("Delete Alarms");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.EDIT_EVENT_DB.ordinal());
        cell.setCellValue("Event Templates");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.EPP.ordinal());
        cell.setCellValue("EPP");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.EXTERNAL_INTEGRATION.ordinal());
        cell.setCellValue("External Integration");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.IMPORT_CONFIGURATION.ordinal());
        cell.setCellValue("Import Config");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.MANAGE_ACTIONS.ordinal());
        cell.setCellValue("Manage Actions");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.MANAGE_AGENT_CFG.ordinal());
        cell.setCellValue("Managet Agent Configs");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.MANAGE_GEO_AREAS.ordinal());
        cell.setCellValue("Manage Geo Areas");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.MANAGE_IMAGE_LIB.ordinal());
        cell.setCellValue("Manage Image Library");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.MANAGE_MAPPING_TBLS.ordinal());
        cell.setCellValue("Manage Mapping Tables");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.MANAGE_OBJECT_QUERIES.ordinal());
        cell.setCellValue("Manage Object Queries");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.MANAGE_PACKAGES.ordinal());
        cell.setCellValue("Manage Packages");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.MANAGE_REPOSITORIES.ordinal());
        cell.setCellValue("Manage Repositories");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.MANAGE_SCRIPTS.ordinal());
        cell.setCellValue("Manage Scripts");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.MANAGE_SERVER_FILES.ordinal());
        cell.setCellValue("Manage Server Files");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.MANAGE_SESSIONS.ordinal());
        cell.setCellValue("Manage Sessions");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.MANAGE_SUMMARY_TBLS.ordinal());
        cell.setCellValue("Manage Summary Tables");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.MANAGE_TOOLS.ordinal());
        cell.setCellValue("Manage Tools");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.MANAGE_2FA_METHODS.ordinal());
        cell.setCellValue("Manage 2FA Methods");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.MANAGE_USERS.ordinal());
        cell.setCellValue("Manage Users");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.MOBILE_DEVICE_LOGIN.ordinal());
        cell.setCellValue("Manage Device Login");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.OBJECT_CATEGORIES.ordinal());
        cell.setCellValue("Object Categories");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.OWN_SCHEDULED_TASKS.ordinal());
        cell.setCellValue("Own Scheduled Tasks");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.PERSISTENT_STORAGE.ordinal());
        cell.setCellValue("Persistent Storage");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.READ_SERVER_FILES.ordinal());
        cell.setCellValue("Read Server Files");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.REGISTER_AGENTS.ordinal());
        cell.setCellValue("Register Agents");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.REPORTING_SERVER.ordinal());
        cell.setCellValue("Reporting Server");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.SCHEDULE_FILE_UPLOAD.ordinal());
        cell.setCellValue("Schedule File Upload");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.SCHEDULE_MAINTENANCE.ordinal());
        cell.setCellValue("Schedule Maintenance");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.SCHEDULE_SCRIPT.ordinal());
        cell.setCellValue("Schedule Scripts");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.SEND_NOTIFICATION.ordinal());
        cell.setCellValue("Send Notifications");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.SERVER_CONFIG.ordinal());
        cell.setCellValue("Server Config");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.SERVER_CONSOLE.ordinal());
        cell.setCellValue("Server Console");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.SETUP_TCP_PROXY.ordinal());
        cell.setCellValue("Setup TCP Proxy");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.SSH_KEY_CONFIGURATION.ordinal());
        cell.setCellValue("SSH Keys");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.UA_NOTIFICATIONS.ordinal());
        cell.setCellValue("User Agent Notifications");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.UNLINK_ISSUES.ordinal());
        cell.setCellValue("Unlink Issues");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.USER_SCHEDULED_TASKS.ordinal());
        cell.setCellValue("User Scheduled Tasks");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.VIEW_ALL_ALARMS.ordinal());
        cell.setCellValue("Vikew All Alarms");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.VIEW_ASSET_CHANGE_LOG.ordinal());
        cell.setCellValue("Asset Change Log");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.VIEW_AUDIT_LOG.ordinal());
        cell.setCellValue("Audit Log");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.VIEW_EVENT_DB.ordinal());
        cell.setCellValue("View Event Templates");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.VIEW_EVENT_LOG.ordinal());
        cell.setCellValue("Event Log");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.VIEW_REPOSITORIES.ordinal());
        cell.setCellValue("View Repositories");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.VIEW_SYSLOG.ordinal());
        cell.setCellValue("Syslog");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.VIEW_TRAP_LOG.ordinal());
        cell.setCellValue("SNMP Trap Log");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(GroupsSheetCells.WEB_SERVICE_DEFINITIONS.ordinal());
        cell.setCellValue("Web Service Definitions");
        cell.setCellStyle(headerStyle);
        sheet.setColumnWidth(GroupsSheetCells.ID.ordinal(), 3072);
        sheet.setColumnWidth(GroupsSheetCells.NAME.ordinal(), 6144);
        sheet.setColumnWidth(GroupsSheetCells.DESCRIPTION.ordinal(), 6144);
        sheet.setColumnWidth(GroupsSheetCells.MEMBERS.ordinal(), 4096);
        Arrays.stream(this.session.getUserDatabaseObjects()).filter(p -> p instanceof UserGroup).sorted(Comparator.comparing(AbstractUserObject::getName)).forEach(element -> {
            UserGroup group = (UserGroup)element;
            HSSFRow row = sheet.createRow(rowNum.getAndIncrement());
            row.createCell(GroupsSheetCells.ID.ordinal()).setCellValue((double)group.getId());
            row.createCell(GroupsSheetCells.NAME.ordinal()).setCellValue(group.getName());
            row.createCell(GroupsSheetCells.DESCRIPTION.ordinal()).setCellValue(group.getDescription());
            boolean firstRow = true;
            int[] nArray = group.getMembers();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                HSSFRow memberRow;
                int memberId = nArray[n2];
                if (firstRow) {
                    memberRow = row;
                    firstRow = false;
                } else {
                    memberRow = sheet.createRow(rowNum.getAndIncrement());
                }
                AbstractUserObject member = this.session.findUserDBObjectById(memberId, null);
                if (member != null) {
                    String name = member instanceof User ? member.getName() : String.valueOf(member.getName()) + " (group)";
                    memberRow.createCell(GroupsSheetCells.MEMBERS.ordinal()).setCellValue(name);
                }
                ++n2;
            }
            this.createPermissionCell(row, GroupsSheetCells.ALL_SCHEDULED_TASKS, 0x100000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.AM_ATTRIBUTE_MANAGE, 0x2000000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.CONFIGURE_TRAPS, 4L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.DELETE_ALARMS, 256L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.EDIT_EVENT_DB, 32L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.EPP, 64L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.EXTERNAL_INTEGRATION, 0x8000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.IMPORT_CONFIGURATION, 0x20000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.MANAGE_ACTIONS, 128L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.MANAGE_AGENT_CFG, 32768L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.MANAGE_GEO_AREAS, 0x200000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.MANAGE_IMAGE_LIB, 0x8000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.MANAGE_MAPPING_TBLS, 0x800000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.MANAGE_OBJECT_QUERIES, 0x800000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.MANAGE_PACKAGES, 512L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.MANAGE_REPOSITORIES, 0x1000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.MANAGE_SCRIPTS, 4096L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.MANAGE_SERVER_FILES, 0x400000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.MANAGE_SESSIONS, 8L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.MANAGE_SUMMARY_TBLS, 0x1000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.MANAGE_TOOLS, 2048L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.MANAGE_2FA_METHODS, 0x1000000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.MANAGE_USERS, 1L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.MOBILE_DEVICE_LOGIN, 262144L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.OBJECT_CATEGORIES, 0x100000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.OWN_SCHEDULED_TASKS, 0x80000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.PERSISTENT_STORAGE, 65536L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.READ_SERVER_FILES, 0x100000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.REGISTER_AGENTS, 524288L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.REPORTING_SERVER, 0x2000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.SCHEDULE_FILE_UPLOAD, 0x400000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.SCHEDULE_MAINTENANCE, 0x800000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.SCHEDULE_SCRIPT, 0x200000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.SEND_NOTIFICATION, 131072L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.SERVER_CONFIG, 2L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.SERVER_CONSOLE, 0x200000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.SETUP_TCP_PROXY, 0x10000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.SSH_KEY_CONFIGURATION, 0x400000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.UA_NOTIFICATIONS, 0x40000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.UNLINK_ISSUES, 0x10000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.USER_SCHEDULED_TASKS, 0x40000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.VIEW_ALL_ALARMS, 0x4000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.VIEW_ASSET_CHANGE_LOG, 0x4000000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.VIEW_AUDIT_LOG, 16384L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.VIEW_EVENT_DB, 16L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.VIEW_EVENT_LOG, 1024L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.VIEW_REPOSITORIES, 0x2000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.VIEW_SYSLOG, 0x20000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.VIEW_TRAP_LOG, 8192L, (AbstractUserObject)group);
            this.createPermissionCell(row, GroupsSheetCells.WEB_SERVICE_DEFINITIONS, 0x80000000000L, (AbstractUserObject)group);
        });
    }

    private void createPermissionCell(HSSFRow row, GroupsSheetCells cellId, long accessBit, AbstractUserObject userObject) {
        row.createCell(cellId.ordinal()).setCellValue((userObject.getSystemRights() & accessBit) != 0L ? "YES" : "NO");
    }

    private void generatePermissionsSheet(HSSFWorkbook wb, HSSFCellStyle headerStyle, List<ObjectAccess> permissions) {
        AtomicInteger rowNum = new AtomicInteger(0);
        HSSFSheet sheet = wb.getSheet("Object Permissions");
        HSSFRow headerRow = sheet.createRow(rowNum.getAndIncrement());
        HSSFCell cell = headerRow.createCell(PermissionsSheetCells.OBJECT_NAME.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Object Name");
        cell = headerRow.createCell(PermissionsSheetCells.USER_OR_GROUP_NAME.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("User/Group name");
        cell = headerRow.createCell(PermissionsSheetCells.INHERIT_ACCESS.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Inherit Access");
        cell = headerRow.createCell(PermissionsSheetCells.READ.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Read");
        cell = headerRow.createCell(PermissionsSheetCells.DELEGATED_READ.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Delegated Read");
        cell = headerRow.createCell(PermissionsSheetCells.MODIFY.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Modify");
        cell = headerRow.createCell(PermissionsSheetCells.EDIT_COMMENTS.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Edit Comments");
        cell = headerRow.createCell(PermissionsSheetCells.EDIT_RESP_USERS.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Edit Responsible Users");
        cell = headerRow.createCell(PermissionsSheetCells.DELETE.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Delete");
        cell = headerRow.createCell(PermissionsSheetCells.CONTROL.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Control");
        cell = headerRow.createCell(PermissionsSheetCells.MAINTENANCE.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Enter/Leave Maintenance");
        cell = headerRow.createCell(PermissionsSheetCells.CONFIGURE_AGENT.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Configure Agent");
        cell = headerRow.createCell(PermissionsSheetCells.READ_AGENT.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Read Agent");
        cell = headerRow.createCell(PermissionsSheetCells.READ_SNMP.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Read SNMP");
        cell = headerRow.createCell(PermissionsSheetCells.TAKE_SCREENSHOT.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Take Screenshots");
        cell = headerRow.createCell(PermissionsSheetCells.EDIT_MAINTENANCE_JOURNAL.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Edit Maintenance Journal");
        cell = headerRow.createCell(PermissionsSheetCells.CREATE_CHILD_OBJECTS.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Create Child Objects");
        cell = headerRow.createCell(PermissionsSheetCells.VIEW_ALARMS.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("View Alarms");
        cell = headerRow.createCell(PermissionsSheetCells.ACKNOWLEDGE_ALARMS.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Acknowledge Alarms");
        cell = headerRow.createCell(PermissionsSheetCells.TERMINATE_ALARMS.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Terminate Alarms");
        cell = headerRow.createCell(PermissionsSheetCells.ACCESS_CONTROL.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Access Control");
        cell = headerRow.createCell(PermissionsSheetCells.CREATE_HELPDESK_ISSUES.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Create Helpdesk Issues");
        cell = headerRow.createCell(PermissionsSheetCells.DOWNLOAD_FILES.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Download Files");
        cell = headerRow.createCell(PermissionsSheetCells.UPLOAD_FILES.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Upload Files");
        cell = headerRow.createCell(PermissionsSheetCells.MANAGE_FILES.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Manage Files");
        cell = headerRow.createCell(PermissionsSheetCells.SEND_EVENTS.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Send Events");
        cell = headerRow.createCell(PermissionsSheetCells.PUSH_DATA.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Push Data");
        sheet.setColumnWidth(PermissionsSheetCells.OBJECT_NAME.ordinal(), 20480);
        sheet.setColumnWidth(PermissionsSheetCells.USER_OR_GROUP_NAME.ordinal(), 4096);
        for (ObjectAccess element : permissions) {
            HSSFRow row = sheet.createRow(rowNum.getAndIncrement());
            row.createCell(PermissionsSheetCells.OBJECT_NAME.ordinal()).setCellValue(element.name);
            row.createCell(PermissionsSheetCells.USER_OR_GROUP_NAME.ordinal()).setCellValue(element.userName);
            row.createCell(PermissionsSheetCells.INHERIT_ACCESS.ordinal()).setCellValue(element.inheritAccessRights ? "YES" : "NO");
            this.createPermissionCell(row, PermissionsSheetCells.READ, 1, element);
            this.createPermissionCell(row, PermissionsSheetCells.DELEGATED_READ, 0x800000, element);
            this.createPermissionCell(row, PermissionsSheetCells.MODIFY, 2, element);
            this.createPermissionCell(row, PermissionsSheetCells.EDIT_COMMENTS, 0x200000, element);
            this.createPermissionCell(row, PermissionsSheetCells.EDIT_RESP_USERS, 0x400000, element);
            this.createPermissionCell(row, PermissionsSheetCells.DELETE, 8, element);
            this.createPermissionCell(row, PermissionsSheetCells.CONTROL, 256, element);
            this.createPermissionCell(row, PermissionsSheetCells.MAINTENANCE, 32768, element);
            this.createPermissionCell(row, PermissionsSheetCells.CONFIGURE_AGENT, 0x100000, element);
            this.createPermissionCell(row, PermissionsSheetCells.READ_AGENT, 65536, element);
            this.createPermissionCell(row, PermissionsSheetCells.READ_SNMP, 131072, element);
            this.createPermissionCell(row, PermissionsSheetCells.TAKE_SCREENSHOT, 262144, element);
            this.createPermissionCell(row, PermissionsSheetCells.EDIT_MAINTENANCE_JOURNAL, 524288, element);
            this.createPermissionCell(row, PermissionsSheetCells.CREATE_CHILD_OBJECTS, 4, element);
            this.createPermissionCell(row, PermissionsSheetCells.VIEW_ALARMS, 16, element);
            this.createPermissionCell(row, PermissionsSheetCells.ACKNOWLEDGE_ALARMS, 64, element);
            this.createPermissionCell(row, PermissionsSheetCells.TERMINATE_ALARMS, 512, element);
            this.createPermissionCell(row, PermissionsSheetCells.ACCESS_CONTROL, 32, element);
            this.createPermissionCell(row, PermissionsSheetCells.CREATE_HELPDESK_ISSUES, 2048, element);
            this.createPermissionCell(row, PermissionsSheetCells.DOWNLOAD_FILES, 4096, element);
            this.createPermissionCell(row, PermissionsSheetCells.UPLOAD_FILES, 8192, element);
            this.createPermissionCell(row, PermissionsSheetCells.MANAGE_FILES, 16384, element);
            this.createPermissionCell(row, PermissionsSheetCells.SEND_EVENTS, 128, element);
            this.createPermissionCell(row, PermissionsSheetCells.PUSH_DATA, 1024, element);
        }
    }

    private void createPermissionCell(HSSFRow row, PermissionsSheetCells cellId, int accessBit, ObjectAccess element) {
        row.createCell(cellId.ordinal()).setCellValue((element.accessRights & accessBit) != 0 ? "YES" : "NO");
    }

    private static void scanACL(AbstractObject currentObject, String parentFullName, List<ObjectAccess> results) {
        String currentFullName = String.valueOf(parentFullName) + "/" + currentObject.getObjectName();
        AclReport.processObject(currentObject, currentFullName, results);
        AbstractObject[] abstractObjectArray = currentObject.getChildrenAsArray();
        int n = abstractObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractObject abstractObject = abstractObjectArray[n2];
            if (abstractObject.hasChildren()) {
                AclReport.scanACL(abstractObject, currentFullName, results);
            }
            ++n2;
        }
    }

    private static void processObject(AbstractObject currentObject, String fullName, List<ObjectAccess> results) {
        if (currentObject.isInheritAccessRights() && currentObject.getAccessList().length == 0) {
            return;
        }
        AccessListElement[] accessListElementArray = currentObject.getAccessList();
        int n = accessListElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            AccessListElement element = accessListElementArray[n2];
            results.add(new ObjectAccess(fullName, currentObject.isInheritAccessRights(), element.getUserId(), element.getAccessRights()));
            ++n2;
        }
    }

    private static class ObjectAccess {
        public String name;
        public int userId;
        public String userName;
        public boolean inheritAccessRights;
        public int accessRights;

        public ObjectAccess(String name, boolean inheritAccessRights, int userId, int accessRights) {
            this.name = name;
            this.inheritAccessRights = inheritAccessRights;
            this.userId = userId;
            this.accessRights = accessRights;
        }
    }
}

