/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.configs.PassiveRackElement;
import org.netxms.client.objects.interfaces.HardwareEntity;

public class Rack
extends GenericObject {
    public static final int FRONT_SIDE_ONLY = 65536;
    private int height;
    private boolean topBottomNumbering;
    private List<PassiveRackElement> passiveElements;

    public Rack(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.height = msg.getFieldAsInt32(441L);
        this.topBottomNumbering = msg.getFieldAsBoolean(539L);
        this.passiveElements = new ArrayList<PassiveRackElement>();
        int count = msg.getFieldAsInt32(361L);
        long fieldId = 0x10000000L;
        int i = 0;
        while (i < count) {
            this.passiveElements.add(new PassiveRackElement(msg, fieldId));
            fieldId += 10L;
            ++i;
        }
    }

    @Override
    public String getObjectClassName() {
        return "Rack";
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    @Override
    public boolean isAlarmsVisible() {
        return true;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isTopBottomNumbering() {
        return this.topBottomNumbering;
    }

    public List<PassiveRackElement> getPassiveElements() {
        return this.passiveElements;
    }

    public List<HardwareEntity> getUnits() {
        ArrayList<HardwareEntity> units = new ArrayList<HardwareEntity>();
        AbstractObject[] abstractObjectArray = this.getChildrenAsArray();
        int n = abstractObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractObject o = abstractObjectArray[n2];
            if (o instanceof HardwareEntity) {
                units.add((HardwareEntity)((Object)o));
            }
            ++n2;
        }
        Collections.sort(units, new Comparator<HardwareEntity>(){

            @Override
            public int compare(HardwareEntity e1, HardwareEntity e2) {
                return e1.getRackPosition() - e2.getRackPosition();
            }
        });
        return units;
    }

    public PassiveRackElement getPassiveElement(long id) {
        for (PassiveRackElement e : this.passiveElements) {
            if (e.getId() != id) continue;
            return e;
        }
        return null;
    }

    public boolean isFrontSideOnly() {
        return (this.flags & 0x10000) != 0;
    }
}

