/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.JavaScriptExecutor;
import org.eclipse.rap.rwt.service.ServiceHandler;
import org.netxms.nxmc.DownloadServiceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DownloadServiceHandler
implements ServiceHandler {
    private static final Logger logger = LoggerFactory.getLogger(DownloadServiceHandler.class);
    public static final String ID = "downloadServiceHandler";
    private static Map<String, DownloadInfo> downloads = new HashMap();
    private static Deque<String> iframeIds = new ArrayDeque(16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DownloadInfo info;
        String id = request.getParameter("id");
        Map map = downloads;
        synchronized (map) {
            info = (DownloadInfo)downloads.get(id);
        }
        if (info == null) {
            logger.debug("Cannot find download with ID {}", (Object)id);
            response.sendError(404);
            return;
        }
        response.setContentType(info.contentType);
        if (info.attachment) {
            response.setHeader("Content-Disposition", "attachment; filename=\"" + info.name + "\"");
        }
        if (info.localFile != null) {
            response.setContentLength((int)info.localFile.length());
            try (FileInputStream in = new FileInputStream(info.localFile);){
                ServletOutputStream out = response.getOutputStream();
                byte[] buffer = new byte[8192];
                int len = ((InputStream)in).read(buffer);
                while (len != -1) {
                    out.write(buffer, 0, len);
                    response.flushBuffer();
                    len = ((InputStream)in).read(buffer);
                }
            }
        } else {
            response.setContentLength(info.data.length);
            response.getOutputStream().write(info.data);
        }
        logger.debug("Download with ID {} completed", (Object)id);
        if (!info.persistent) {
            map = downloads;
            synchronized (map) {
                downloads.remove(id);
                if (info.localFile != null) {
                    info.localFile.delete();
                }
                iframeIds.push(info.iframeId);
            }
        }
    }

    public static String createDownloadUrl(String id) {
        StringBuilder url = new StringBuilder(RWT.getServiceManager().getServiceHandlerUrl("downloadServiceHandler"));
        url.append("&id=");
        url.append(id);
        return RWT.getResponse().encodeURL(url.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDownload(String id, String name, File localFile, String contentType) {
        Map map = downloads;
        synchronized (map) {
            downloads.put(id, new DownloadInfo(name, localFile, contentType, null, false, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDownload(String id, String name, File localFile, String contentType, boolean persistent, boolean attachment) {
        Map map = downloads;
        synchronized (map) {
            downloads.put(id, new DownloadInfo(name, localFile, contentType, null, persistent, attachment));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDownload(String id, String name, byte[] data, String contentType) {
        Map map = downloads;
        synchronized (map) {
            downloads.put(id, new DownloadInfo(name, null, contentType, data, false, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDownload(String id) {
        Map map = downloads;
        synchronized (map) {
            DownloadInfo info = (DownloadInfo)downloads.remove(id);
            if (info != null) {
                iframeIds.push(info.iframeId);
                if (info.localFile != null) {
                    info.localFile.delete();
                }
                logger.debug("Download with ID {} removed", (Object)id);
            }
        }
    }

    public static void startDownload(String id) {
        JavaScriptExecutor executor = (JavaScriptExecutor)RWT.getClient().getService(JavaScriptExecutor.class);
        if (executor != null) {
            StringBuilder js = new StringBuilder();
            js.append("var hiddenIFrameID = 'hiddenDownloader_");
            js.append(DownloadServiceHandler.getIFrameId((String)id));
            js.append("', iframe = document.getElementById(hiddenIFrameID);");
            js.append("if (iframe === null) {");
            js.append("   iframe = document.createElement('iframe');");
            js.append("   iframe.id = hiddenIFrameID;");
            js.append("   iframe.style.display = 'none';");
            js.append("   document.body.appendChild(iframe);");
            js.append("}");
            js.append("iframe.src = '");
            js.append(DownloadServiceHandler.createDownloadUrl((String)id));
            js.append("';");
            executor.execute(js.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getIFrameId(String id) {
        Map map = downloads;
        synchronized (map) {
            DownloadInfo info = (DownloadInfo)downloads.get(id);
            return info != null ? info.iframeId : "";
        }
    }
}

