/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc;

import io.github.secretx33.resourceresolver.PathMatchingResourcePatternResolver;
import io.github.secretx33.resourceresolver.Resource;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.rap.rwt.application.Application;
import org.eclipse.rap.rwt.application.ApplicationConfiguration;
import org.eclipse.rap.rwt.application.ExceptionHandler;
import org.eclipse.rap.rwt.internal.application.ApplicationImpl;
import org.eclipse.rap.rwt.internal.resources.ContentBuffer;
import org.eclipse.rap.rwt.service.ResourceLoader;
import org.eclipse.rap.rwt.service.ServiceHandler;
import org.eclipse.swt.SWT;
import org.netxms.client.services.ServiceManager;
import org.netxms.nxmc.DownloadServiceHandler;
import org.netxms.nxmc.Startup;
import org.netxms.nxmc.VideoServiceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApplicationConfiguration
implements ApplicationConfiguration {
    private static Logger logger = LoggerFactory.getLogger(WebApplicationConfiguration.class);
    private final ContentBuffer concatenatedScript = new ContentBuffer();
    private final ResourceLoader genericResourceLoader = new /* Unavailable Anonymous Inner Class!! */;

    public void configure(Application app) {
        this.addJsLibrary("/js/dom-to-image-more.js");
        this.addJsLibrary("/js/download.js");
        this.addJsLibrary("/js/longpress.js");
        this.addJsLibrary("/js/msgproxy.js");
        this.addJsLibrary("/js/rwt-util.js");
        app.addResource(SWT.getVersion() + "/nxmc-library.js", (ResourceLoader)new /* Unavailable Anonymous Inner Class!! */);
        ((ApplicationImpl)app).getApplicationContext().getStartupPage().addJsLibrary("rwt-resources/" + SWT.getVersion() + "/nxmc-library.js");
        this.registerAllResources(app, "vncviewer");
        app.addServiceHandler("downloadServiceHandler", (ServiceHandler)new DownloadServiceHandler());
        app.addServiceHandler("videoServiceHandler", (ServiceHandler)new VideoServiceHandler());
        app.addStyleSheet("org.netxms.themes.light", "/themes/light.css");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.rap.rwt.webclient.themeId", "org.netxms.themes.light");
        app.addEntryPoint("/nxmc-light.app", Startup.class, properties);
        app.setOperationMode(Application.OperationMode.SWT_COMPATIBILITY);
        app.setExceptionHandler((ExceptionHandler)new /* Unavailable Anonymous Inner Class!! */);
        RuntimeLog.addLogListener((ILogListener)new /* Unavailable Anonymous Inner Class!! */);
        ServiceManager.registerClassLoader((ClassLoader)this.getClass().getClassLoader());
    }

    private void registerAllResources(Application app, String basePath) {
        logger.debug("Scanning resource path \"{}\"", (Object)basePath);
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            for (Resource r : resolver.getResources("classpath:" + basePath + "/**/*")) {
                int i;
                String uri = r.getURI().toString();
                if (uri.endsWith("/") || (i = uri.lastIndexOf(basePath + "/")) <= 0) continue;
                String resourcePath = uri.substring(i);
                app.addResource(resourcePath, this.genericResourceLoader);
                logger.debug("Registered resource \"{}\"", (Object)resourcePath);
            }
        }
        catch (IOException e) {
            logger.error("Error registering resources", (Throwable)e);
        }
    }

    private void addJsLibrary(String path) {
        try {
            this.concatenatedScript.append(this.getClass().getClassLoader().getResourceAsStream(path));
        }
        catch (IOException e) {
            logger.error("Cannot add JS library", (Throwable)e);
        }
    }
}

