/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class KeyValuePairEditDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(KeyValuePairEditDialog.class);
    private LabeledText textKey;
    private LabeledText textValue;
    private String key;
    private String value;
    private String keyLabel;
    private String valueLabel;
    private boolean showValue;
    private boolean isNew;

    public KeyValuePairEditDialog(Shell parentShell, String key, String value, boolean showValue, boolean isNew, String keyLabel, String valueLabel) {
        super(parentShell);
        this.key = key;
        this.value = value;
        this.showValue = showValue;
        this.isNew = isNew;
        this.keyLabel = keyLabel;
        this.valueLabel = valueLabel;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.isNew ? this.i18n.tr("Create Value") : this.i18n.tr("Edit Value"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.textKey = new LabeledText(dialogArea, 0);
        this.textKey.setLabel(this.keyLabel);
        this.textKey.getTextControl().setTextLimit(256);
        if (this.key != null) {
            this.textKey.setText(this.key);
        }
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.textKey.setLayoutData((Object)gd);
        if (this.showValue && !this.isNew) {
            this.textKey.setEditable(false);
        }
        if (this.showValue) {
            this.textValue = new LabeledText(dialogArea, 0);
            this.textValue.setLabel(this.valueLabel);
            if (this.value != null) {
                this.textValue.setText(this.value);
            }
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.textValue.setLayoutData((Object)gd);
            if (this.key != null) {
                this.textValue.setFocus();
            }
        }
        return dialogArea;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    protected void okPressed() {
        this.key = this.textKey.getText();
        if (this.showValue) {
            this.value = this.textValue.getText();
        }
        super.okPressed();
    }
}

