/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.assetmanagement.views.helpers;

import java.util.Map;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Asset;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.modules.assetmanagement.views.helpers.AssetPropertyReader;

public class AssetListFilter
extends ViewerFilter
implements AbstractViewerFilter {
    private String filterString = null;
    private NXCSession session = Registry.getSession();
    private AssetPropertyReader propertyReader;

    public AssetListFilter(AssetPropertyReader propertyReader) {
        this.propertyReader = propertyReader;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.filterString == null || this.filterString.isEmpty()) {
            return true;
        }
        if (((AbstractObject)element).getObjectName().toLowerCase().contains(this.filterString)) {
            return true;
        }
        Asset asset = this.getAsset(element);
        if (asset == null) {
            return false;
        }
        for (Map.Entry p : asset.getProperties().entrySet()) {
            if (!this.propertyReader.valueToText((String)p.getKey(), (String)p.getValue()).toLowerCase().contains(this.filterString)) continue;
            return true;
        }
        return false;
    }

    private Asset getAsset(Object element) {
        if (element instanceof Asset) {
            return (Asset)element;
        }
        return (Asset)this.session.findObjectById(((AbstractObject)element).getAssetId(), Asset.class);
    }

    public void setFilterString(String string) {
        this.filterString = string != null ? string.toLowerCase() : null;
    }
}

