/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logwatch.widgets.helpers;

import org.netxms.nxmc.modules.logwatch.widgets.helpers.LogParser;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Text;

@Root(name="match", strict=false)
public class LogParserMatch {
    @Text
    private String match = ".*";
    @Attribute(required=false)
    private String invert = null;
    @Attribute(required=false)
    private Integer repeatCount = null;
    @Attribute(required=false)
    private Integer repeatInterval = null;
    @Attribute(required=false)
    private String reset = null;

    protected LogParserMatch() {
    }

    public LogParserMatch(String match, boolean invert, Integer repeatCount, Integer repeatInterval, boolean reset) {
        this.match = match;
        this.setInvert(invert);
        this.repeatCount = repeatCount;
        this.repeatInterval = repeatInterval;
        this.setReset(reset);
    }

    public Integer getRepeatCount() {
        return this.repeatCount == null ? 0 : this.repeatCount;
    }

    public void setRepeatCount(Integer repeatCount) {
        this.repeatCount = repeatCount;
    }

    public Integer getRepeatInterval() {
        return this.repeatInterval == null ? 0 : this.repeatInterval;
    }

    public void setRepeatInterval(Integer repeatInterval) {
        this.repeatInterval = repeatInterval;
    }

    public boolean getReset() {
        return this.reset == null ? true : LogParser.stringToBoolean((String)this.reset);
    }

    public void setReset(boolean reset) {
        this.reset = reset ? null : "false";
    }

    public String getMatch() {
        return this.match;
    }

    public void setMatch(String match) {
        this.match = match;
    }

    public boolean getInvert() {
        return LogParser.stringToBoolean((String)this.invert);
    }

    public void setInvert(boolean invert) {
        this.invert = LogParser.booleanToString((boolean)invert);
    }

    public int getTimeRagne() {
        if (this.repeatInterval == null) {
            return 0;
        }
        int interval = this.repeatInterval;
        if (interval % 60 == 0 && (interval /= 60) % 60 == 0) {
            interval /= 60;
        }
        return interval;
    }

    public int getTimeUnit() {
        if (this.repeatInterval == null) {
            return 0;
        }
        int unit = 0;
        if (this.repeatInterval % 60 == 0) {
            ++unit;
            if (this.repeatInterval % 3600 == 0) {
                ++unit;
            }
        }
        return unit;
    }
}

