/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.gef4.zest.layouts.LayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.interfaces.EntityLayout;
import org.eclipse.gef4.zest.layouts.interfaces.LayoutContext;

public class SparseTree
implements LayoutAlgorithm {
    private static final int ROW_BINDING_DELTA = 10;
    private static final int MINIMAL_DISTANCE = 10;
    private LayoutContext context;

    public void setLayoutContext(LayoutContext context) {
        this.context = context;
    }

    public void applyLayout(boolean clean) {
        ArrayList row;
        int currRowIdx;
        EntityLayout[] entitiesToLayout = this.context.getEntities();
        ArrayList rows = new ArrayList();
        for (int i = 0; i < entitiesToLayout.length; ++i) {
            this.addToRow(rows, entitiesToLayout[i]);
        }
        Collections.sort(rows, new /* Unavailable Anonymous Inner Class!! */);
        for (currRowIdx = 0; currRowIdx < rows.size(); ++currRowIdx) {
            row = (ArrayList)rows.get(currRowIdx);
            Collections.sort(row, new /* Unavailable Anonymous Inner Class!! */);
            for (int currNodeIdx = 1; currNodeIdx < row.size(); ++currNodeIdx) {
                EntityLayout currNode = (EntityLayout)row.get(currNodeIdx);
                EntityLayout prevNode = (EntityLayout)row.get(currNodeIdx - 1);
                double currNodePos = currNode.getLocation().x;
                double prevNodePos = prevNode.getLocation().x;
                double minimalPos = prevNodePos + prevNode.getSize().width + 10.0;
                if (!(currNodePos < minimalPos)) continue;
                currNode.setLocation(minimalPos, currNode.getLocation().y);
            }
        }
        for (currRowIdx = rows.size() - 1; currRowIdx > 0; --currRowIdx) {
            row = (ArrayList)rows.get(currRowIdx);
            double leftmostX = ((EntityLayout)row.get((int)0)).getLocation().x;
            int firstChildIdx = 0;
            EntityLayout parent = this.getParentNode((EntityLayout)row.get(0));
            for (int currNodeIdx = 1; currNodeIdx < row.size(); ++currNodeIdx) {
                EntityLayout currNode = (EntityLayout)row.get(currNodeIdx);
                EntityLayout nextParent = this.getParentNode(currNode);
                if (parent == nextParent) continue;
                if (parent != null) {
                    this.centerNode(rows, currRowIdx, firstChildIdx, parent, leftmostX, ((EntityLayout)row.get((int)(currNodeIdx - 1))).getLocation().x + ((EntityLayout)row.get((int)(currNodeIdx - 1))).getSize().width);
                }
                parent = nextParent;
                leftmostX = currNode.getLocation().x;
                firstChildIdx = currNodeIdx;
            }
            if (parent == null) continue;
            EntityLayout currNode = (EntityLayout)row.get(row.size() - 1);
            this.centerNode(rows, currRowIdx, firstChildIdx, parent, leftmostX, currNode.getLocation().x + currNode.getSize().width);
        }
    }

    private EntityLayout getParentNode(EntityLayout e) {
        EntityLayout[] parents = e.getPredecessingEntities();
        return parents.length > 0 ? parents[0] : null;
    }

    private void centerNode(ArrayList<ArrayList<EntityLayout>> rows, int currRowIdx, int firstChildIdx, EntityLayout node, double leftmostX, double rightmostX) {
        block3: {
            double shift;
            block2: {
                double newX = leftmostX + (rightmostX - leftmostX) / 2.0 - node.getSize().width / 2.0;
                shift = newX - node.getLocation().x;
                if (!(shift > 0.0)) break block2;
                ArrayList<EntityLayout> row = rows.get(currRowIdx - 1);
                node.setLocation(newX, node.getLocation().y);
                int index = row.indexOf(node);
                if (index == -1) break block3;
                for (int i = index + 1; i < row.size(); ++i) {
                    EntityLayout n = row.get(i);
                    n.setLocation(n.getLocation().x + shift, n.getLocation().y);
                }
                break block3;
            }
            ArrayList<EntityLayout> row = rows.get(currRowIdx);
            for (int i = firstChildIdx; i < row.size(); ++i) {
                EntityLayout n = row.get(i);
                n.setLocation(n.getLocation().x - shift, n.getLocation().y);
                this.shiftChildNodes(rows, currRowIdx + 1, n, -shift);
            }
        }
    }

    private void shiftChildNodes(ArrayList<ArrayList<EntityLayout>> rows, int currRowIdx, EntityLayout parent, double shift) {
        if (rows.size() <= currRowIdx) {
            return;
        }
        ArrayList<EntityLayout> row = rows.get(currRowIdx);
        for (EntityLayout n : row) {
            if (this.getParentNode(n) != parent) continue;
            n.setLocation(n.getLocation().x + shift, n.getLocation().y);
            this.shiftChildNodes(rows, currRowIdx + 1, n, shift);
        }
    }

    private void addToRow(ArrayList<ArrayList<EntityLayout>> rows, EntityLayout node) {
        double nodeY = node.getLocation().y;
        for (ArrayList<EntityLayout> row : rows) {
            double rowY = row.get((int)0).getLocation().y;
            if (!(Math.abs(nodeY - rowY) <= 10.0)) continue;
            row.add(node);
            return;
        }
        ArrayList<EntityLayout> newRow = new ArrayList<EntityLayout>();
        newRow.add(node);
        rows.add(newRow);
    }
}

