/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.views;

import org.netxms.client.SessionListener;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.NetworkMap;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewNotRestoredException;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.networkmaps.views.PredefinedMapView;
import org.xnap.commons.i18n.I18n;

public class ContextPredefinedMapView
extends PredefinedMapView {
    private final I18n i18n = LocalizationHelper.getI18n(ContextPredefinedMapView.class);
    private NetworkMap map;
    private SessionListener clientListener;

    public ContextPredefinedMapView(NetworkMap map) {
        super("objects.context.network-map." + Long.toString(map.getObjectId()));
        this.map = map;
    }

    protected ContextPredefinedMapView() {
        this.objectMoveLocked = false;
        this.readOnly = true;
    }

    public View cloneView() {
        ContextPredefinedMapView view = (ContextPredefinedMapView)super.cloneView();
        view.map = this.map;
        return view;
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.clientListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.clientListener);
    }

    protected void saveZoom(AbstractObject object) {
    }

    protected void loadZoom(AbstractObject object) {
        PreferenceStore settings = PreferenceStore.getInstance();
        this.viewer.zoomTo(settings.getAsDouble(this.getBaseId() + ".zoom", 1.0));
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof AbstractObject && ((AbstractObject)context).hasNetworkMap(this.map.getObjectId());
    }

    public int getPriority() {
        return this.map.getDisplayPriority() > 0 ? this.map.getDisplayPriority() : 65535;
    }

    public String getName() {
        return this.map.getObjectName();
    }

    protected void onObjectUpdate(AbstractObject object) {
    }

    public void setupMapControl() {
        super.onObjectChange((AbstractObject)this.map);
        super.setupMapControl();
    }

    protected void onObjectChange(AbstractObject object) {
    }

    protected Object getContext() {
        return this.map;
    }

    protected void contextChanged(Object oldContext, Object newContext) {
    }

    public void saveState(Memento memento) {
        super.saveState(memento);
        memento.set("map", this.map.getObjectId());
    }

    public void restoreState(Memento memento) throws ViewNotRestoredException {
        super.restoreState(memento);
        this.map = (NetworkMap)this.session.findObjectById(memento.getAsLong("map", 0L), NetworkMap.class);
        if (this.map == null) {
            throw new ViewNotRestoredException(this.i18n.tr("Invalid map ID"));
        }
    }

    static /* synthetic */ void access$001(ContextPredefinedMapView x0, AbstractObject x1) {
        super.onObjectUpdate(x1);
    }
}

