/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.widgets.helpers;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.netxms.client.maps.LinkDataLocation;
import org.netxms.client.maps.NetworkMapLink;

public class MultiLabelConnectionLocator
extends ConnectionLocator {
    private NetworkMapLink link;
    private LinkDataLocation labelLocation;

    public MultiLabelConnectionLocator(Connection connection, NetworkMapLink link, LinkDataLocation labelLocation) {
        super(connection);
        this.link = link;
        this.labelLocation = labelLocation;
    }

    protected Point getLocation(PointList points) {
        double y;
        double x;
        double firstObjectX = points.getFirstPoint().preciseX();
        double firstObjectY = points.getFirstPoint().preciseY();
        double secondObjectX = points.getLastPoint().preciseX();
        double secondObjectY = points.getLastPoint().preciseY();
        double adj = Math.abs(secondObjectX - firstObjectX);
        double opp = Math.abs(secondObjectY - firstObjectY);
        double theta = Math.atan(opp / adj);
        double length = Math.sqrt(Math.pow(adj, 2.0) + Math.pow(opp, 2.0));
        double sectionLenght = length / 11.0;
        double elementPart = sectionLenght * 3.0;
        double locationLenght = this.link.getDuplicateCount() != 0 ? (this.link.isDirectionInverted() ? elementPart / (double)(this.link.getDuplicateCount() + 2) * (double)(this.link.getDuplicateCount() + 2 - (this.link.getPosition() + 1)) : elementPart / (double)(this.link.getDuplicateCount() + 2) * (double)(this.link.getPosition() + 1)) : elementPart / 100.0 * (double)this.link.getConfig().getLabelPosition();
        if (this.labelLocation == LinkDataLocation.OBJECT1) {
            locationLenght += sectionLenght * 1.0;
        }
        if (this.labelLocation == LinkDataLocation.CENTER) {
            locationLenght += sectionLenght * 4.0;
        }
        if (this.labelLocation == LinkDataLocation.OBJECT2) {
            locationLenght += sectionLenght * 7.0;
        }
        if (firstObjectX >= secondObjectX && firstObjectY >= secondObjectY) {
            x = firstObjectX - locationLenght * Math.cos(theta);
            y = firstObjectY - locationLenght * Math.sin(theta);
        } else if (firstObjectX >= secondObjectX && firstObjectY < secondObjectY) {
            x = firstObjectX - locationLenght * Math.cos(-theta);
            y = firstObjectY - locationLenght * Math.sin(-theta);
        } else if (firstObjectX < secondObjectX && firstObjectY > secondObjectY) {
            x = firstObjectX + locationLenght * Math.cos(-theta);
            y = firstObjectY + locationLenght * Math.sin(-theta);
        } else {
            x = firstObjectX + locationLenght * Math.cos(theta);
            y = firstObjectY + locationLenght * Math.sin(theta);
        }
        return new Point(x, y);
    }
}

