/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import java.util.Locale;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.MacAddress;
import org.netxms.client.constants.SensorDeviceClass;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.base.widgets.LabeledCombo;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.MacAddressValidator;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.ObjectNameValidator;
import org.netxms.nxmc.tools.TextFieldValidator;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class CreateSensorDialog
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(CreateSensorDialog.class);
    private LabeledText nameField;
    private LabeledText aliasField;
    private LabeledText macAddrField;
    private LabeledCombo deviceClassField;
    private ObjectSelector gatewayNodeField;
    private LabeledText deviceAddressField;
    private LabeledSpinner modbusUnitIdField;
    private LabeledText vendorField;
    private LabeledText modelField;
    private LabeledText serialNumberField;
    private String name;
    private String alias;
    private SensorDeviceClass deviceClass;
    private MacAddress macAddress;
    private String deviceAddress;
    private long gatewayNodeId;
    private short modbusUnitId;
    private String vendor;
    private String model;
    private String serialNumber;

    public CreateSensorDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Create Sensor"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.nameField = new LabeledText(dialogArea, 0);
        this.nameField.setLabel(this.i18n.tr("Name"));
        this.nameField.getTextControl().setTextLimit(255);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 400;
        gd.horizontalSpan = 2;
        this.nameField.setLayoutData((Object)gd);
        this.aliasField = new LabeledText(dialogArea, 0);
        this.aliasField.setLabel(this.i18n.tr("Alias"));
        this.aliasField.getTextControl().setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.aliasField.setLayoutData((Object)gd);
        this.deviceClassField = new LabeledCombo(dialogArea, 0);
        this.deviceClassField.setLabel(this.i18n.tr("Device class"));
        this.deviceClassField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Locale locale = LocalizationHelper.getLocale();
        for (SensorDeviceClass c : (SensorDeviceClass[])SensorDeviceClass.class.getEnumConstants()) {
            this.deviceClassField.add(c.getDisplayName(locale));
        }
        this.deviceClassField.select(0);
        this.gatewayNodeField = new ObjectSelector(dialogArea, 0, true);
        this.gatewayNodeField.setLabel(this.i18n.tr("Gateway node"));
        this.gatewayNodeField.setObjectClass(Node.class);
        this.gatewayNodeField.setClassFilter(ObjectSelectionDialog.createNodeSelectionFilter((boolean)false));
        this.gatewayNodeField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.macAddrField = new LabeledText(dialogArea, 0);
        this.macAddrField.setLabel(this.i18n.tr("MAC address"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.macAddrField.setLayoutData((Object)gd);
        this.modbusUnitIdField = new LabeledSpinner(dialogArea, 0);
        this.modbusUnitIdField.setLabel(this.i18n.tr("Modbus unit ID"));
        this.modbusUnitIdField.setRange(0, 255);
        this.modbusUnitIdField.setSelection(255);
        this.deviceAddressField = new LabeledText(dialogArea, 0);
        this.deviceAddressField.setLabel(this.i18n.tr("Device address"));
        this.deviceAddressField.getTextControl().setTextLimit(255);
        this.deviceAddressField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.vendorField = new LabeledText(dialogArea, 0);
        this.vendorField.setLabel(this.i18n.tr("Vendor"));
        this.vendorField.getTextControl().setTextLimit(255);
        this.vendorField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.modelField = new LabeledText(dialogArea, 0);
        this.modelField.setLabel(this.i18n.tr("Model"));
        this.modelField.getTextControl().setTextLimit(255);
        this.modelField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.serialNumberField = new LabeledText(dialogArea, 0);
        this.serialNumberField.setLabel(this.i18n.tr("Serial number"));
        this.serialNumberField.getTextControl().setTextLimit(63);
        this.serialNumberField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        return dialogArea;
    }

    protected void okPressed() {
        if (!WidgetHelper.validateTextInput((LabeledText)this.nameField, (TextFieldValidator)new ObjectNameValidator()) || !WidgetHelper.validateTextInput((LabeledText)this.macAddrField, (TextFieldValidator)new MacAddressValidator(true))) {
            WidgetHelper.adjustWindowSize((Window)this);
            return;
        }
        try {
            this.name = this.nameField.getText().trim();
            this.alias = this.aliasField.getText().trim();
            this.deviceClass = SensorDeviceClass.getByValue((int)this.deviceClassField.getSelectionIndex());
            this.gatewayNodeId = this.gatewayNodeField.getObjectId();
            this.macAddress = this.macAddrField.getText().trim().isEmpty() ? new MacAddress() : MacAddress.parseMacAddress((String)this.macAddrField.getText());
            this.modbusUnitId = (short)this.modbusUnitIdField.getSelection();
            this.deviceAddress = this.deviceAddressField.getText().trim();
            this.vendor = this.vendorField.getText().trim();
            this.model = this.modelField.getText().trim();
            this.serialNumber = this.serialNumberField.getText().trim();
            super.okPressed();
        }
        catch (Exception e) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)this.i18n.tr("Error"), (String)String.format(this.i18n.tr("Internal error: %s"), e.getLocalizedMessage()));
            WidgetHelper.adjustWindowSize((Window)this);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public MacAddress getMacAddress() {
        return this.macAddress;
    }

    public SensorDeviceClass getDeviceClass() {
        return this.deviceClass;
    }

    public String getDeviceAddress() {
        return this.deviceAddress;
    }

    public long getGatewayNodeId() {
        return this.gatewayNodeId;
    }

    public short getModbusUnitId() {
        return this.modbusUnitId;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getModel() {
        return this.model;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }
}

