/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Zone;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.dialogs.DialogWithFilter;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.helpers.ZoneSelectionDialogComparator;
import org.netxms.nxmc.modules.objects.dialogs.helpers.ZoneSelectionDialogFilter;
import org.netxms.nxmc.modules.objects.widgets.helpers.DecoratingObjectLabelProvider;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class ZoneSelectionDialog
extends DialogWithFilter {
    private I18n i18n = LocalizationHelper.getI18n(ZoneSelectionDialog.class);
    private Zone zone;
    private TableViewer zoneList;
    private ZoneSelectionDialogFilter filter;

    public ZoneSelectionDialog(Shell parent) {
        super(parent);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Select Zone"));
        newShell.setSize(300, 500);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        NXCSession session = Registry.getSession();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.horizontalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        String[] names = new String[]{this.i18n.tr("Name")};
        int[] widths = new int[]{200};
        this.zoneList = new SortableTableViewer(dialogArea, names, widths, 0, 128, 68100);
        this.zoneList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.zoneList.setComparator((ViewerComparator)new ZoneSelectionDialogComparator());
        this.zoneList.setLabelProvider((IBaseLabelProvider)new DecoratingObjectLabelProvider());
        this.filter = new ZoneSelectionDialogFilter();
        this.zoneList.addFilter((ViewerFilter)this.filter);
        this.setFilterClient((StructuredViewer)this.zoneList, (AbstractViewerFilter)this.filter);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.zoneList.getTable().setLayoutData((Object)gd);
        this.zoneList.setInput((Object)session.getAllZones());
        this.zoneList.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.zoneList.getSelection();
        if (selection.size() <= 0) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please select zone object"));
            return;
        }
        this.zone = (Zone)selection.getFirstElement();
        super.okPressed();
    }

    public int getZoneUIN() {
        return this.zone.getUIN();
    }

    public long getZoneObjectId() {
        return this.zone.getObjectId();
    }

    public String getZoneName() {
        return this.zone.getObjectName();
    }
}

