/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.SessionListener;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.NodeSubObjectView;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.xnap.commons.i18n.I18n;

public abstract class NodeSubObjectView
extends ObjectView {
    private I18n i18n = LocalizationHelper.getI18n(NodeSubObjectView.class);
    protected Composite mainArea;
    protected SessionListener sessionListener = null;
    protected boolean fullObjectSync;

    public NodeSubObjectView(String name, ImageDescriptor image, String id, boolean hasFilter) {
        super(name, image, id, hasFilter);
    }

    protected void createContent(Composite parent) {
        PreferenceStore coreStore = PreferenceStore.getInstance();
        this.fullObjectSync = coreStore.getAsBoolean("ObjectBrowser.FullSync", false);
        this.mainArea = new Composite(parent, 0);
        this.mainArea.setLayout((Layout)new FillLayout());
        parent.setLayout((Layout)new FormLayout());
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        fd.right = new FormAttachment(100, 0);
        this.mainArea.setLayoutData((Object)fd);
        this.sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.sessionListener);
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof AbstractNode;
    }

    public void activate() {
        this.checkAndSyncChildren(this.getObject());
        super.activate();
    }

    public void dispose() {
        this.session.removeListener(this.sessionListener);
        super.dispose();
    }

    protected void onObjectChange(AbstractObject object) {
        this.checkAndSyncChildren(object);
    }

    private void checkAndSyncChildren(AbstractObject object) {
        HashSet otherObjects;
        AbstractObject thisObject;
        if (this.fullObjectSync) {
            this.refresh();
            return;
        }
        AbstractObject abstractObject = thisObject = object.hasChildren() && !object.areChildrenSynchronized() ? object : null;
        if (thisObject == null) {
            otherObjects = new HashSet();
            this.collectObjectsForChildrenSync(object, otherObjects);
        } else {
            otherObjects = null;
        }
        if (thisObject != null || otherObjects != null && !otherObjects.isEmpty()) {
            this.syncChildren(thisObject, otherObjects);
        } else {
            this.refresh();
        }
    }

    protected void collectObjectsForChildrenSync(AbstractObject object, Set<AbstractObject> objectsForSync) {
    }

    private void syncChildren(AbstractObject thisObject, Set<AbstractObject> otherObjects) {
        Composite label = new Composite(this.mainArea.getParent(), 0);
        label.setLayout((Layout)new GridLayout());
        label.setBackground(label.getDisplay().getSystemColor(25));
        Label labelText = new Label(label, 0x1000000);
        labelText.setFont(JFaceResources.getBannerFont());
        labelText.setText(this.i18n.tr("Loading..."));
        labelText.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        labelText.setBackground(label.getBackground());
        label.moveAbove(null);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        fd.right = new FormAttachment(100, 0);
        label.setLayoutData((Object)fd);
        this.mainArea.getParent().layout(true, true);
        2 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    public abstract boolean needRefreshOnObjectChange(AbstractObject var1);
}

