/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.io.Serializable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.objects.AbstractNode;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.base.actions.CopyTableRowsAction;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewNotRestoredException;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.AdHocObjectView;
import org.netxms.nxmc.modules.objects.views.helpers.RouteLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class RouteView
extends AdHocObjectView {
    private final I18n i18n = LocalizationHelper.getI18n(RouteView.class);
    public static final int COLUMN_HOP = 0;
    public static final int COLUMN_NODE = 1;
    public static final int COLUMN_NEXT_HOP = 2;
    public static final int COLUMN_TYPE = 3;
    public static final int COLUMN_NAME = 4;
    private CLabel status;
    private SortableTableViewer viewer;
    private AbstractNode source;
    private AbstractNode destination;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;
    private Action actionCopyRowToClipboard;

    private static String generateName(AbstractNode source, AbstractNode destination, long contextId) {
        if (source.getObjectId() == contextId) {
            return LocalizationHelper.getI18n(RouteView.class).tr("Route to {0}", (Object)destination.getObjectName());
        }
        if (destination.getObjectId() == contextId) {
            return LocalizationHelper.getI18n(RouteView.class).tr("Route from {0}", (Object)source.getObjectName());
        }
        return LocalizationHelper.getI18n(RouteView.class).tr("Route {0} - {1}", (Object)source.getObjectName(), (Object)destination.getObjectName());
    }

    public RouteView(AbstractNode source, AbstractNode destination, long contextId) {
        super(RouteView.generateName((AbstractNode)source, (AbstractNode)destination, (long)contextId), ResourceManager.getImageDescriptor((String)"icons/object-views/route.png"), "objects.routes." + source.getObjectId() + "." + destination.getObjectId(), contextId, contextId, false);
        this.source = source;
        this.destination = destination;
    }

    protected RouteView() {
        super("", ResourceManager.getImageDescriptor((String)"icons/object-views/route.png"), "objects.routes.0.0", 0L, 0L, false);
    }

    public View cloneView() {
        RouteView view = (RouteView)super.cloneView();
        view.source = this.source;
        view.destination = this.destination;
        return view;
    }

    protected void postClone(View view) {
        super.postClone(view);
        this.refresh();
    }

    protected void createContent(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.status = new CLabel(parent, 0);
        this.status.setLayoutData((Object)new GridData(4, 4, true, false));
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 4, true, false));
        String[] names = new String[]{this.i18n.tr("Hop"), this.i18n.tr("Node"), this.i18n.tr("Next hop"), this.i18n.tr("Type"), this.i18n.tr("Name")};
        int[] widths = new int[]{80, 150, 150, 150, 150};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 1024, 65538);
        this.viewer.disableSorting();
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new RouteLabelProvider());
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.actionCopyRowToClipboard = new CopyTableRowsAction((ColumnViewer)this.viewer, true);
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, true);
        this.actionExportAllToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, false);
        this.createContextMenu();
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.refresh();
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener & Serializable)m -> this.fillContextMenu(m));
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopyRowToClipboard);
        manager.add((IAction)this.actionExportToCsv);
    }

    public String getFullName() {
        return RouteView.generateName((AbstractNode)this.source, (AbstractNode)this.destination, (long)0L);
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void saveState(Memento memento) {
        super.saveState(memento);
        memento.set("source", this.source.getObjectId());
        memento.set("destination", this.destination.getObjectId());
    }

    public void restoreState(Memento memento) throws ViewNotRestoredException {
        super.restoreState(memento);
        this.source = (AbstractNode)this.session.findObjectById(memento.getAsLong("source", 0L), AbstractNode.class);
        this.destination = (AbstractNode)this.session.findObjectById(memento.getAsLong("destination", 0L), AbstractNode.class);
        if (this.source == null) {
            throw new ViewNotRestoredException(this.i18n.tr("Source object no longer exists or is not accessible"));
        }
        if (this.destination == null) {
            throw new ViewNotRestoredException(this.i18n.tr("Destination object no longer exists or is not accessible"));
        }
    }
}

