/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.SessionListener;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Template;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.base.windows.MainWindow;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.dialogs.TemplateRemovalDialog;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.TemplateTargets;
import org.netxms.nxmc.modules.objects.views.helpers.TemplateTargetsComparator;
import org.netxms.nxmc.modules.objects.views.helpers.TemplateTargetsFilter;
import org.netxms.nxmc.modules.objects.views.helpers.TemplateTargetsLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class TemplateTargets
extends ObjectView {
    private final I18n i18n = LocalizationHelper.getI18n(TemplateTargets.class);
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_ZONE = 2;
    public static final int COLUMN_PRIMARY_HOST_NAME = 3;
    public static final int COLUMN_DESCRIPTION = 4;
    private SessionListener sessionListener;
    private SortableTableViewer viewer;
    private TemplateTargetsFilter filter;
    private TemplateTargetsLabelProvider labelProvider;
    private Action actionAddTarget;
    private Action actionRemoveTarget;
    private Action actionGoToObject;

    public TemplateTargets() {
        super("Targets", ResourceManager.getImageDescriptor((String)"icons/object-views/nodes.png"), "objects.template-targets", true);
    }

    protected void createContent(Composite parent) {
        String[] names = new String[]{this.i18n.tr("ID"), this.i18n.tr("Name"), this.i18n.tr("Zone"), this.i18n.tr("Primary host name"), this.i18n.tr("Description")};
        int[] widths = new int[]{60, 300, 300, 300, 300};
        this.viewer = new SortableTableViewer(parent, names, widths, 1, 128, 65538);
        this.labelProvider = new TemplateTargetsLabelProvider(object -> this.viewer.update(object, null));
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new TemplateTargetsComparator(this.labelProvider));
        this.filter = new TemplateTargetsFilter(this.labelProvider);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.filter);
        this.viewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)"InterfacesView.TableViewer");
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createContextMenu();
        this.sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.sessionListener);
    }

    private void createContextMenu() {
        4 menuMgr = new /* Unavailable Anonymous Inner Class!! */;
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionAddTarget);
        manager.add((IContributionItem)new Separator());
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionAddTarget);
        manager.add((IContributionItem)new Separator());
    }

    private void createActions() {
        this.actionAddTarget = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAddTarget.setImageDescriptor(SharedIcons.ADD_OBJECT);
        this.actionRemoveTarget = new /* Unavailable Anonymous Inner Class!! */;
        this.actionRemoveTarget.setEnabled(false);
        this.actionGoToObject = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void bindObjects() {
        long parentId = this.getObjectId();
        if (parentId == 0L) {
            return;
        }
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getWindow().getShell(), ObjectSelectionDialog.createDataCollectionTargetSelectionFilter());
        if (dlg.open() != 0) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void removeTemplate() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        long parentId = this.getObjectId();
        TemplateRemovalDialog dlg = new TemplateRemovalDialog(this.getWindow().getShell());
        if (dlg.open() != 0) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void gotToObject() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        AbstractObject object = (AbstractObject)selection.getFirstElement();
        MainWindow.switchToObject((long)object.getObjectId(), (long)0L);
    }

    public void refresh() {
        if (this.getObject() != null) {
            this.viewer.setInput((Object)this.getObject().getChildrenAsArray());
            this.viewer.packColumns();
        } else {
            this.viewer.setInput((Object)new AbstractNode[0]);
        }
    }

    protected void onObjectChange(AbstractObject object) {
        if (object != null && this.isActive()) {
            this.refresh();
        }
    }

    public void activate() {
        super.activate();
        this.refresh();
    }

    public boolean isValidForContext(Object context) {
        return context instanceof Template;
    }

    public void dispose() {
        this.session.removeListener(this.sessionListener);
        super.dispose();
    }

    protected void onObjectUpdate(AbstractObject object) {
        this.refresh();
    }

    public int getPriority() {
        return 100;
    }
}

