/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.NetworkService;
import org.netxms.nxmc.modules.objects.views.helpers.NetworkServiceListLabelProvider;
import org.netxms.nxmc.modules.objects.views.helpers.NodeSubObjectFilter;
import org.netxms.nxmc.resources.StatusDisplayInfo;

public class NetworkServiceFilter
extends NodeSubObjectFilter {
    private NetworkServiceListLabelProvider lp;

    public NetworkServiceFilter(NetworkServiceListLabelProvider lp) {
        this.lp = lp;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        NetworkService ns = (NetworkService)element;
        if (this.filterString == null || this.filterString.isEmpty()) {
            return true;
        }
        boolean matched = false;
        if (Long.toString(ns.getObjectId()).contains(this.filterString)) {
            matched = true;
        } else if (ns.getObjectName().contains(this.filterString)) {
            matched = true;
        } else if (StatusDisplayInfo.getStatusText((ObjectStatus)ns.getStatus()).contains(this.filterString)) {
            matched = true;
        } else if (this.lp.types[ns.getServiceType()].contains(this.filterString)) {
            matched = true;
        } else if (ns.getIpAddress().getHostAddress().contains(this.filterString)) {
            matched = true;
        } else if (Integer.toString(ns.getProtocol()).contains(this.filterString)) {
            matched = true;
        } else if (Integer.toString(ns.getPort()).contains(this.filterString)) {
            matched = true;
        } else if (ns.getRequest().contains(this.filterString)) {
            matched = true;
        } else if (ns.getResponse().contains(this.filterString)) {
            matched = true;
        } else if (this.lp.getPollerName(ns).contains(this.filterString)) {
            matched = true;
        } else if (Integer.toString(ns.getPollCount()).contains(this.filterString)) {
            matched = true;
        }
        return matched;
    }
}

