/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.views;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISaveablePart2;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.views.AbstractCommandResults;

public class ServerCommandResults
extends AbstractCommandResults
implements ISaveablePart2 {
    public static final String ID = "org.netxms.ui.eclipse.objecttools.views.ServerCommandResults";
    private String lastCommand = null;
    private Action actionRestart;
    private Action actionStop;
    private Map<String, String> lastInputValues = null;
    private boolean isRunning = false;
    private List<String> maskedFields;
    private long alarmId;

    @Override
    protected void createActions() {
        super.createActions();
        Messages.get();
        this.actionRestart = new Action(Messages.LocalCommandResults_Restart, SharedIcons.RESTART){

            public void run() {
                ServerCommandResults.this.executeCommand(ServerCommandResults.this.lastCommand, ServerCommandResults.this.alarmId, ServerCommandResults.this.lastInputValues, ServerCommandResults.this.maskedFields);
            }
        };
        this.actionRestart.setEnabled(false);
        this.actionStop = new Action("Stop", SharedIcons.TERMINATE){

            public void run() {
                ServerCommandResults.this.stopCommand();
            }
        };
        this.actionStop.setEnabled(false);
    }

    @Override
    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IAction)this.actionStop);
        manager.add((IContributionItem)new Separator());
        super.fillLocalPullDown(manager);
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IAction)this.actionStop);
        manager.add((IContributionItem)new Separator());
        super.fillLocalToolBar(manager);
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IAction)this.actionStop);
        manager.add((IContributionItem)new Separator());
        super.fillContextMenu(manager);
    }

    public void executeCommand(final String command, final long alarmId, final Map<String, String> inputValues, final List<String> maskedFields) {
        if (this.isRunning) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Command already running!");
            return;
        }
        this.isRunning = true;
        this.actionRestart.setEnabled(false);
        this.actionStop.setEnabled(true);
        this.createOutputStream();
        this.lastCommand = command;
        this.alarmId = alarmId;
        this.lastInputValues = inputValues;
        this.maskedFields = maskedFields;
        Messages.get();
        ConsoleJob job = new ConsoleJob(String.format(Messages.ObjectToolsDynamicMenu_ExecuteOnNode, this.session.getObjectName(this.nodeId)), null, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.ObjectToolsDynamicMenu_CannotExecuteOnNode, ServerCommandResults.this.session.getObjectName(ServerCommandResults.this.nodeId));
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                try {
                    ServerCommandResults.this.session.executeServerCommand(ServerCommandResults.this.nodeId, alarmId, command, inputValues, maskedFields, true, ServerCommandResults.this.getOutputListener(), null);
                    Messages.get();
                    ServerCommandResults.this.writeToOutputStream(Messages.LocalCommandResults_Terminated);
                }
                finally {
                    ServerCommandResults.this.closeOutputStream();
                }
            }

            protected void jobFinalize() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).ServerCommandResults.this.actionRestart.setEnabled(true);
                        (this).ServerCommandResults.this.actionStop.setEnabled(false);
                        (this).ServerCommandResults.this.isRunning = false;
                    }
                });
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }

    private void stopCommand() {
        if (this.streamId > 0L) {
            ConsoleJob job = new ConsoleJob("Stop server command for node: " + this.session.getObjectName(this.nodeId), null, "org.netxms.ui.eclipse.objecttools", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    ServerCommandResults.this.session.stopServerCommand(ServerCommandResults.this.streamId);
                }

                protected void jobFinalize() {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            (this).ServerCommandResults.this.actionStop.setEnabled(false);
                            (this).ServerCommandResults.this.actionRestart.setEnabled(true);
                        }
                    });
                }

                protected String getErrorMessage() {
                    return "Failed to stop server command for node: " + ServerCommandResults.this.session.getObjectName(ServerCommandResults.this.nodeId);
                }
            };
            job.start();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.stopCommand();
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.isRunning;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isRunning;
    }

    public int promptToSaveOnClose() {
        return MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Stop command", (String)("Do you wish to stop the command \"" + this.lastCommand + "\"? ")) ? 0 : 2;
    }
}

