/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.reports.acl;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.netxms.client.AccessListElement;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.usermanager.reports.acl.constants.PermissionsSheetCells;

public abstract class AbstractAclReport {
    protected final String SHEET_USERS = "Users";
    protected final String SHEET_GROUPS = "Groups";
    protected final String SHEET_PERMISSIONS = "Object Permissions";
    protected NXCSession session = ConsoleSharedData.getSession();
    private String outputFileName;

    public AbstractAclReport(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public void execute() throws IOException, NXCException {
        ArrayList<ObjectAccess> permissions = new ArrayList<ObjectAccess>();
        AbstractObject[] topLevelObjects = this.session.getTopLevelObjects();
        Object object = topLevelObjects;
        int n = topLevelObjects.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractObject topLevelObject = object[n2];
            AbstractAclReport.scanACL(topLevelObject, "", permissions);
            ++n2;
        }
        for (ObjectAccess row : permissions) {
            AbstractUserObject user = this.session.findUserDBObjectById(row.userId, null);
            if (user != null) {
                row.userName = user.getName();
                if (user instanceof User) continue;
                row.userName = String.valueOf(row.userName) + " (group)";
                continue;
            }
            row.userName = String.format("DELETED [%d]", row.userId);
        }
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFFont headerFont = wb.createFont();
        headerFont.setBold(true);
        XSSFCellStyle headerCellStyle = wb.createCellStyle();
        headerCellStyle.setFont((Font)headerFont);
        wb.createSheet();
        wb.createSheet();
        wb.createSheet();
        wb.setSheetName(0, "Users");
        wb.setSheetName(1, "Groups");
        wb.setSheetName(2, "Object Permissions");
        this.generateUserSheet(wb, headerCellStyle);
        this.generateGroupsSheet(wb, headerCellStyle);
        this.generatePermissionsSheet(wb, headerCellStyle, permissions);
        object = null;
        Object var7_11 = null;
        try (FileOutputStream fileOut = new FileOutputStream(this.outputFileName);){
            wb.write((OutputStream)fileOut);
            ((OutputStream)fileOut).close();
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }

    protected void createPermissionCell(XSSFRow row, int columnIndex, long accessBit, AbstractUserObject userObject) {
        row.createCell(columnIndex).setCellValue((userObject.getSystemRights() & accessBit) != 0L ? "YES" : "NO");
    }

    protected abstract void generateUserSheet(XSSFWorkbook var1, XSSFCellStyle var2);

    protected abstract void generateGroupsSheet(XSSFWorkbook var1, XSSFCellStyle var2);

    protected abstract void generatePermissionsSheet(XSSFWorkbook var1, XSSFCellStyle var2, List<ObjectAccess> var3);

    protected void createPermissionCell(XSSFRow row, PermissionsSheetCells cellId, int accessBit, ObjectAccess element) {
        row.createCell(cellId.ordinal()).setCellValue((element.accessRights & accessBit) != 0 ? "YES" : "NO");
    }

    protected static void scanACL(AbstractObject currentObject, String parentFullName, List<ObjectAccess> results) {
        String currentFullName = String.valueOf(parentFullName) + "/" + currentObject.getObjectName();
        AbstractAclReport.processObject(currentObject, currentFullName, results);
        AbstractObject[] abstractObjectArray = currentObject.getChildrenAsArray();
        int n = abstractObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractObject abstractObject = abstractObjectArray[n2];
            if (abstractObject.hasChildren()) {
                AbstractAclReport.scanACL(abstractObject, currentFullName, results);
            }
            ++n2;
        }
    }

    protected static void processObject(AbstractObject currentObject, String fullName, List<ObjectAccess> results) {
        if (currentObject.isInheritAccessRights() && currentObject.getAccessList().length == 0) {
            return;
        }
        AccessListElement[] accessListElementArray = currentObject.getAccessList();
        int n = accessListElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            AccessListElement element = accessListElementArray[n2];
            results.add(new ObjectAccess(fullName, currentObject.isInheritAccessRights(), element.getUserId(), element.getAccessRights()));
            ++n2;
        }
    }

    protected static class ObjectAccess {
        public String name;
        public int userId;
        public String userName;
        public boolean inheritAccessRights;
        public int accessRights;

        public ObjectAccess(String name, boolean inheritAccessRights, int userId, int accessRights) {
            this.name = name;
            this.inheritAccessRights = inheritAccessRights;
            this.userId = userId;
            this.accessRights = accessRights;
        }
    }
}

