/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.dialogs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.server.ServerVariable;
import org.netxms.ui.eclipse.serverconfig.Messages;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class VariableEditDialog
extends Dialog {
    private LabeledText textName;
    private Text textValue;
    private Spinner spinnerValue;
    private Button trueValue;
    private Button falseValue;
    private ColorSelector colorSelector;
    private Combo comboValue;
    private ServerVariable variable;
    private Map<Integer, String> valueMap;
    private String name;
    private String value;

    public VariableEditDialog(Shell parentShell, ServerVariable variable) {
        super(parentShell);
        this.variable = variable;
    }

    protected void configureShell(Shell newShell) {
        String string;
        super.configureShell(newShell);
        if (this.variable.getName() == null) {
            Messages.get();
            string = Messages.VariableEditDialog_TitleCreate;
        } else {
            Messages.get();
            string = Messages.VariableEditDialog_TitleEdit;
        }
        newShell.setText(string);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.textName = new LabeledText(dialogArea, 0);
        Messages.get();
        this.textName.setLabel(Messages.VariableEditDialog_Name);
        this.textName.getTextControl().setTextLimit(63);
        if (this.variable.getName() != null) {
            this.textName.setText(this.variable.getName());
            this.textName.getTextControl().setEditable(false);
        }
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.textName.setLayoutData((Object)gd);
        if (!this.variable.getUnit().isEmpty()) {
            layout.numColumns = 2;
            gd.horizontalSpan = 2;
        }
        switch (this.variable.getDataType()) {
            case BOOLEAN: {
                this.trueValue = new Button(dialogArea, 16);
                this.trueValue.setText("&True");
                this.trueValue.setSelection(this.variable.getValueAsBoolean());
                this.falseValue = new Button(dialogArea, 16);
                this.falseValue.setText("&False");
                this.falseValue.setSelection(!this.trueValue.getSelection());
                if (this.variable.getName() == null) break;
                this.trueValue.setFocus();
                break;
            }
            case CHOICE: {
                this.valueMap = new HashMap<Integer, String>();
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                Messages.get();
                this.comboValue = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)Messages.VariableEditDialog_Value, (Object)gd);
                for (Map.Entry e : this.variable.getPossibleValues().entrySet()) {
                    this.comboValue.add((String)e.getValue());
                    int index = this.comboValue.getItemCount() - 1;
                    this.valueMap.put(index, (String)e.getKey());
                    if (!((String)e.getKey()).equals(this.variable.getValue())) continue;
                    this.comboValue.select(index);
                }
                if (this.variable.getName() == null) break;
                this.comboValue.setFocus();
                break;
            }
            case COLOR: {
                Messages.get();
                this.colorSelector = WidgetHelper.createLabeledColorSelector((Composite)dialogArea, (String)Messages.VariableEditDialog_Value, (Object)"WidgetHelper::default_layout_data");
                if (this.variable.getValue().isEmpty()) break;
                this.colorSelector.setColorValue(ColorConverter.parseColorDefinition((String)this.variable.getValue()));
                break;
            }
            case INTEGER: {
                Messages.get();
                this.spinnerValue = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)Messages.VariableEditDialog_Value, (int)0, (int)(this.variable.getPossibleValues().isEmpty() ? 0xFFFFFF : Integer.parseInt((String)this.variable.getPossibleValues().keySet().toArray()[0])), (Object)"WidgetHelper::default_layout_data");
                this.spinnerValue.setSelection(this.variable.getValueAsInt());
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                this.spinnerValue.setLayoutData((Object)gd);
                if (!this.variable.getUnit().isEmpty()) {
                    Label unit = new Label(dialogArea, 0);
                    unit.setText(this.variable.getUnit());
                    gd = new GridData();
                    gd.grabExcessHorizontalSpace = true;
                    gd.verticalIndent = 15;
                    gd.horizontalAlignment = 4;
                    unit.setLayoutData((Object)gd);
                }
                if (this.variable.getName() == null) break;
                this.spinnerValue.setFocus();
                break;
            }
            case STRING: 
            case PASSWORD: {
                Messages.get();
                this.textValue = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2048, (int)300, (String)Messages.VariableEditDialog_Value, (String)this.variable.getValue(), (Object)"WidgetHelper::default_layout_data");
                this.textValue.setTextLimit(2000);
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                this.textValue.setLayoutData((Object)gd);
                if (this.variable.getName() == null) break;
                this.textValue.setFocus();
            }
        }
        return dialogArea;
    }

    public String getVarName() {
        return this.name;
    }

    public String getVarValue() {
        return this.value;
    }

    protected void okPressed() {
        this.name = this.textName.getText();
        switch (this.variable.getDataType()) {
            case BOOLEAN: {
                this.value = this.trueValue.getSelection() ? "1" : "0";
                break;
            }
            case CHOICE: {
                if (this.comboValue.getSelectionIndex() == -1) {
                    MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please select valid value and then press OK");
                    return;
                }
                this.value = this.valueMap.get(this.comboValue.getSelectionIndex());
                break;
            }
            case COLOR: {
                if (this.colorSelector.getColorValue() == null) break;
                this.value = ColorConverter.rgbToCss((RGB)this.colorSelector.getColorValue());
                break;
            }
            case INTEGER: {
                this.value = this.spinnerValue.getText();
                break;
            }
            case STRING: 
            case PASSWORD: {
                this.value = this.textValue.getText();
            }
        }
        super.okPressed();
    }
}

