/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.imagelibrary.views;

import java.io.File;
import java.io.FileInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.base.NXCommon;
import org.netxms.client.LibraryImage;
import org.netxms.client.NXCSession;
import org.netxms.client.ProgressListener;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.imagelibrary.Activator;
import org.netxms.ui.eclipse.imagelibrary.Messages;
import org.netxms.ui.eclipse.imagelibrary.dialogs.ImagePropertiesDialog;
import org.netxms.ui.eclipse.imagelibrary.views.helpers.ImageCategory;
import org.netxms.ui.eclipse.imagelibrary.views.helpers.ImageLibraryContentProvider;
import org.netxms.ui.eclipse.imagelibrary.views.helpers.ImageLibraryLabelProvider;
import org.netxms.ui.eclipse.imagelibrary.widgets.ImagePreview;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.SortableTreeViewer;

public class ImageLibrary
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.imagelibrary.view.imagelibrary";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_PROTECTED = 2;
    public static final int COLUMN_GUID = 3;
    private NXCSession session = ConsoleSharedData.getSession();
    private SessionListener sessionListener;
    private Map<String, ImageCategory> imageCategories = new HashMap<String, ImageCategory>();
    private SashForm splitter;
    private SortableTreeViewer viewer;
    private ImagePreview imagePreview;
    private Action actionNew;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionRefresh;

    public void createPartControl(final Composite parent) {
        FillLayout layout = new FillLayout();
        parent.setLayout((Layout)layout);
        this.splitter = new SashForm(parent, 256);
        String[] names = new String[]{"Name", "MIME type", "Protected", "GUID"};
        int[] widths = new int[]{400, 120, 80, 200};
        this.viewer = new SortableTreeViewer((Composite)this.splitter, names, widths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ImageLibraryContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ImageLibraryLabelProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String n1 = e1 instanceof LibraryImage ? ((LibraryImage)e1).getName() : ((ImageCategory)e1).getName();
                String n2 = e2 instanceof LibraryImage ? ((LibraryImage)e2).getName() : ((ImageCategory)e2).getName();
                return n1.compareToIgnoreCase(n2);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ImageLibrary.this.viewer.getSelection();
                if (selection.getFirstElement() instanceof ImageCategory) {
                    if (ImageLibrary.this.viewer.getExpandedState(selection.getFirstElement())) {
                        ImageLibrary.this.viewer.collapseToLevel(selection.getFirstElement(), -1);
                    } else {
                        ImageLibrary.this.viewer.expandToLevel(selection.getFirstElement(), 1);
                    }
                } else if (selection.getFirstElement() instanceof LibraryImage) {
                    ImageLibrary.this.editImage();
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ImageLibrary.this.viewer.getSelection();
                if (selection.size() == 1 && selection.getFirstElement() instanceof LibraryImage) {
                    ImageLibrary.this.imagePreview.setImage((LibraryImage)selection.getFirstElement());
                } else {
                    ImageLibrary.this.imagePreview.setImage(null);
                }
            }
        });
        this.imagePreview = new ImagePreview((Composite)this.splitter, 2048);
        this.splitter.setWeights(new int[]{70, 30});
        this.createActions();
        this.createPopupMenu();
        this.contributeToActionBars();
        this.refreshImages();
        this.sessionListener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() != 11) {
                    return;
                }
                final UUID guid = (UUID)n.getObject();
                final boolean update = n.getSubCode() == 201L;
                parent.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (update) {
                            ImageLibrary.this.updateImageLocalCopy(guid);
                        } else {
                            ImageLibrary.this.removeImageLocalCopy(guid);
                        }
                    }
                });
            }
        };
        this.session.addListener(this.sessionListener);
    }

    public void dispose() {
        this.session.removeListener(this.sessionListener);
        super.dispose();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void createActions() {
        Messages.get();
        this.actionNew = new Action(Messages.ImageLibrary_ActionUpload){

            public void run() {
                ImageLibrary.this.addImage();
            }
        };
        this.actionNew.setImageDescriptor(SharedIcons.ADD_OBJECT);
        Messages.get();
        this.actionEdit = new Action(Messages.ImageLibrary_ActionEdit){

            public void run() {
                ImageLibrary.this.editImage();
            }
        };
        this.actionEdit.setImageDescriptor(SharedIcons.EDIT);
        Messages.get();
        this.actionDelete = new Action(Messages.ImageLibrary_ActionDelete){

            public void run() {
                ImageLibrary.this.deleteImages();
            }
        };
        this.actionDelete.setImageDescriptor(SharedIcons.DELETE_OBJECT);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                ImageLibrary.this.refreshImages();
            }
        };
    }

    private String verifyImageFile(String fileName) throws Exception {
        ImageData image = new ImageData(fileName);
        return switch (image.type) {
            case 0, 1 -> "image/bmp";
            case 2 -> "image/gif";
            case 3 -> "image/x-icon";
            case 4 -> "image/jpeg";
            case 5 -> "image/png";
            case 6 -> "image/tiff";
            default -> "image/unknown";
        };
    }

    private void addImage() {
        ImagePropertiesDialog dialog = new ImagePropertiesDialog(this.getSite().getShell(), this.imageCategories.keySet());
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            Object o = selection.getFirstElement();
            if (o instanceof ImageCategory) {
                dialog.setDefaultCategory(((ImageCategory)o).getName());
            } else if (o instanceof LibraryImage) {
                dialog.setDefaultCategory(((LibraryImage)o).getCategory());
            }
        }
        if (dialog.open() == 0) {
            this.uploadNewImage(dialog.getName(), dialog.getCategory(), dialog.getFileName());
        }
    }

    private void editImage() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        if (selection.getFirstElement() instanceof LibraryImage) {
            LibraryImage image = (LibraryImage)selection.getFirstElement();
            ImagePropertiesDialog dialog = new ImagePropertiesDialog(this.getSite().getShell(), this.imageCategories.keySet());
            dialog.setName(image.getName());
            dialog.setDefaultCategory(image.getCategory());
            if (dialog.open() == 0) {
                this.doImageUpdate(image, dialog.getName(), dialog.getCategory(), dialog.getFileName());
            }
        }
    }

    private void doImageUpdate(final LibraryImage image, String name, String category, final String fileName) {
        if (!image.isProtected()) {
            image.setName(name);
            image.setCategory(category);
        }
        Messages.get();
        new ConsoleJob(Messages.ImageLibrary_UpdateJob, (IWorkbenchPart)this, "org.netxms.ui.eclipse.imagelibrary", null){

            protected void runInternal(final IProgressMonitor monitor) throws Exception {
                if (fileName != null) {
                    String mimeType = ImageLibrary.this.verifyImageFile(fileName);
                    try (FileInputStream stream = null;){
                        long fileSize = new File(fileName).length();
                        stream = new FileInputStream(fileName);
                        byte[] imageData = new byte[(int)fileSize];
                        stream.read(imageData);
                        image.setBinaryData(imageData, mimeType);
                    }
                }
                ImageLibrary.this.session.modifyImage(image, new ProgressListener(){
                    private long prevDone = 0L;

                    public void setTotalWorkAmount(long workTotal) {
                        Messages.get();
                        monitor.beginTask(Messages.ImageLibrary_UpdateImage, (int)workTotal);
                    }

                    public void markProgress(long workDone) {
                        monitor.worked((int)(workDone - this.prevDone));
                        this.prevDone = workDone;
                    }
                });
                monitor.done();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).ImageLibrary.this.viewer.refresh();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ImageLibrary_UpdateError;
            }
        }.start();
    }

    protected void uploadNewImage(final String name, final String category, final String fileName) {
        Messages.get();
        new ConsoleJob(Messages.ImageLibrary_UploadJob, (IWorkbenchPart)this, "org.netxms.ui.eclipse.imagelibrary", null){

            protected void runInternal(final IProgressMonitor monitor) throws Exception {
                String mimeType = ImageLibrary.this.verifyImageFile(fileName);
                final LibraryImage image = new LibraryImage(UUID.randomUUID(), name, category, mimeType);
                long fileSize = new File(fileName).length();
                try (FileInputStream stream = null;){
                    stream = new FileInputStream(fileName);
                    byte[] imageData = new byte[(int)fileSize];
                    stream.read(imageData);
                    image.setBinaryData(imageData, mimeType);
                }
                ImageLibrary.this.session.createImage(image, new ProgressListener(){
                    private long prevDone = 0L;

                    public void setTotalWorkAmount(long workTotal) {
                        Messages.get();
                        monitor.beginTask(Messages.ImageLibrary_UploadImage, (int)workTotal);
                    }

                    public void markProgress(long workDone) {
                        monitor.worked((int)(workDone - this.prevDone));
                        this.prevDone = workDone;
                    }
                });
                monitor.done();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ImageCategory category = (this).ImageLibrary.this.imageCategories.get(image.getCategory());
                        if (category == null) {
                            category = new ImageCategory(image.getCategory());
                            (this).ImageLibrary.this.imageCategories.put(category.getName(), category);
                        }
                        category.addImage(image);
                        (this).ImageLibrary.this.viewer.refresh();
                        (this).ImageLibrary.this.viewer.setSelection((ISelection)new StructuredSelection((Object)image));
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ImageLibrary_UploadError;
            }
        }.start();
    }

    protected void deleteImages() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getSite().getShell(), (String)"Delete Library Images", (String)"Do you really want to delete selected images?")) {
            return;
        }
        final HashSet<String> categoryDeleteList = new HashSet<String>();
        final HashSet<LibraryImage> deleteList = new HashSet<LibraryImage>();
        for (Object o : selection.toList()) {
            if (o instanceof LibraryImage) {
                deleteList.add((LibraryImage)o);
                continue;
            }
            if (!(o instanceof ImageCategory)) continue;
            deleteList.addAll(((ImageCategory)o).getImages());
            categoryDeleteList.add(((ImageCategory)o).getName());
        }
        if (deleteList.isEmpty()) {
            return;
        }
        new ConsoleJob("Delete library images", (IWorkbenchPart)this, "org.netxms.ui.eclipse.imagelibrary", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (LibraryImage i : deleteList) {
                    ImageLibrary.this.session.deleteImage(i);
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (LibraryImage i : deleteList) {
                            (this).ImageLibrary.this.imageCategories.get(i.getCategory()).removeImage(i.getGuid());
                        }
                        if (!categoryDeleteList.isEmpty()) {
                            for (String c : categoryDeleteList) {
                                (this).ImageLibrary.this.imageCategories.remove(c);
                            }
                        }
                        (this).ImageLibrary.this.viewer.refresh();
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot delete library image";
            }
        }.start();
    }

    private void createPopupMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ImageLibrary.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.viewer.getTree());
        this.viewer.getTree().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && selection.getFirstElement() instanceof LibraryImage) {
            manager.add((IAction)this.actionEdit);
        }
        if (!selection.isEmpty()) {
            boolean protectedFound = false;
            for (Object o : selection.toList()) {
                if (o instanceof LibraryImage && ((LibraryImage)o).isProtected()) {
                    protectedFound = true;
                    break;
                }
                if (!(o instanceof ImageCategory) || !((ImageCategory)o).hasProtectedImages()) continue;
                protectedFound = true;
                break;
            }
            if (!protectedFound) {
                manager.add((IAction)this.actionDelete);
            }
        }
    }

    private void contributeToActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.add((IAction)this.actionNew);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.actionRefresh);
    }

    private void refreshImages() {
        Messages.get();
        new ConsoleJob(Messages.ImageLibrary_ReloadJob, (IWorkbenchPart)this, "org.netxms.ui.eclipse.imagelibrary", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List imageLibrary = ImageLibrary.this.session.getImageLibrary();
                Collections.sort(imageLibrary);
                int i = 0;
                while (i < imageLibrary.size()) {
                    LibraryImage image = (LibraryImage)imageLibrary.get(i);
                    if (!image.isComplete()) {
                        try {
                            LibraryImage completeImage = ImageLibrary.this.session.getImage(image.getGuid());
                            imageLibrary.set(i, completeImage);
                        }
                        catch (Exception e) {
                            Activator.logError("Exception in ImageLibrary.refreshImages()", e);
                        }
                    }
                    ++i;
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ImageLibrary.this.refreshUI(imageLibrary);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ImageLibrary_LoadError;
            }
        }.start();
    }

    private void refreshUI(List<LibraryImage> imageLibrary) {
        this.imageCategories.clear();
        for (LibraryImage image : imageLibrary) {
            ImageCategory category = this.imageCategories.get(image.getCategory());
            if (category == null) {
                category = new ImageCategory(image.getCategory());
                this.imageCategories.put(category.getName(), category);
            }
            category.addImage(image);
        }
        this.viewer.setInput(this.imageCategories);
    }

    private void updateImageLocalCopy(final UUID guid) {
        ConsoleJob job = new ConsoleJob("Load library image", (IWorkbenchPart)this, "org.netxms.ui.eclipse.imagelibrary", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final LibraryImage image = ImageLibrary.this.session.getImage(guid);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        IStructuredSelection selection = (IStructuredSelection)(this).ImageLibrary.this.viewer.getSelection();
                        UUID selectedGuid = selection.size() == 1 && selection.getFirstElement() instanceof LibraryImage ? ((LibraryImage)selection.getFirstElement()).getGuid() : NXCommon.EMPTY_GUID;
                        ImageCategory category = (this).ImageLibrary.this.imageCategories.get(image.getCategory());
                        if (category == null) {
                            category = new ImageCategory(image.getCategory());
                            (this).ImageLibrary.this.imageCategories.put(category.getName(), category);
                        }
                        category.addImage(image);
                        (this).ImageLibrary.this.viewer.refresh();
                        if (selectedGuid.equals(image.getGuid())) {
                            (this).ImageLibrary.this.viewer.setSelection((ISelection)new StructuredSelection((Object)image));
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot load library image";
            }
        };
        job.setUser(false);
        job.start();
    }

    private void removeImageLocalCopy(UUID guid) {
        for (ImageCategory c : this.imageCategories.values()) {
            if (!c.removeImage(guid)) continue;
            this.viewer.refresh();
            break;
        }
    }
}

