/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.preferencepages;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class AppearancePage
extends PropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(AppearancePage.class);
    private Button checkVerticalLayout;
    private Button checkShowServerClock;
    private Button checkShowWelcomePage;
    private Button checkShowTrayIcon;

    public AppearancePage() {
        super(LocalizationHelper.getI18n(AppearancePage.class).tr("Appearance"));
    }

    protected Control createContents(Composite parent) {
        PreferenceStore settings = PreferenceStore.getInstance();
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkVerticalLayout = new Button(dialogArea, 32);
        this.checkVerticalLayout.setText(this.i18n.tr("&Vertical layout of perspective switcher"));
        this.checkVerticalLayout.setSelection(settings.getAsBoolean("Appearance.VerticalLayout", true));
        this.checkShowServerClock = new Button(dialogArea, 32);
        this.checkShowServerClock.setText(this.i18n.tr("Show server &clock"));
        this.checkShowServerClock.setSelection(settings.getAsBoolean("Appearance.ShowServerClock", false));
        this.checkShowWelcomePage = new Button(dialogArea, 32);
        this.checkShowWelcomePage.setText(this.i18n.tr("Show post-upgrade &welcome page on startup"));
        this.checkShowWelcomePage.setSelection(!settings.getAsBoolean("WelcomePage.Disabled", !Registry.getSession().getClientConfigurationHintAsBoolean("EnableWelcomePage", true)));
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set("Appearance.VerticalLayout", this.checkVerticalLayout.getSelection());
        settings.set("Appearance.ShowServerClock", this.checkShowServerClock.getSelection());
        settings.set("WelcomePage.Disabled", !this.checkShowWelcomePage.getSelection());
        return true;
    }
}

